% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseSim.R
\name{profileSimParametric}
\alias{profileSimParametric}
\title{Simulate complete DNA profiles given IBD coefficients}
\usage{
profileSimParametric(
  kappa = NULL,
  delta = NULL,
  states = NULL,
  N = 1,
  afreqList = NULL,
  seed = NULL,
  returnValue = c("singletons", "alleles", "genotypes")
)
}
\arguments{
\item{kappa}{A probability vector of length 3, giving a set of realised kappa
coefficients (between two noninbred individuals).}

\item{delta}{A probability vector of length 9, giving a set of condensed
identity coefficients (Jacquard coefficients).}

\item{states}{An integer vector of length \code{N}, with entries in 1-9. Each
entry gives the identity state of the corresponding marker. (See details.)}

\item{N}{A positive integer: the number of complete profiles to be simulated}

\item{afreqList}{A list of numeric vectors. Each vector is the allele
frequencies of a marker.}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{returnValue}{Either "singleton" (default) or "alleles". (see Value).}
}
\value{
A list of length \code{N}, whose entries are determined by \code{returnValue},
as explained in \code{\link[=markerSimParametric]{markerSimParametric()}}.
}
\description{
This function generalises \code{\link[=markerSimParametric]{markerSimParametric()}} in the same way that
\code{\link[=profileSim]{profileSim()}} generalises \code{\link[=markerSim]{markerSim()}}.
}
\examples{
# A single profile with 9 markers, each with forced identity state
profileSimParametric(states = 1:9, afreqList = NorwegianFrequencies[1:9])

}
