% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_split_extract.R
\name{str_split_extract}
\alias{str_split_extract}
\title{Extract the result of a positional split string}
\usage{
str_split_extract(string, pattern, position)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something coercible to one.}

\item{pattern}{Pattern to look for. This may also contain regular expression.}

\item{position}{Index position to return from the character vector.}
}
\value{
A character vector.
}
\description{
Split up a string into pieces and extract the results using a specific index position. Mathematically, you can interpret it as follows:

Given a character string, \code{S}, extract the element at a given position, \code{k}, from the result of splitting \code{S} by a given pattern, \code{m}.
}
\examples{
code <- c("HS-IB-EDE", "OG-OYO-CAS-0121", "NY-ILR-NIG-036")

str_split_extract(code, "-", 1)

str_split_extract(code, "-", 4)

}
