% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{datasets.download_files}
\alias{datasets.download_files}
\title{Download Foundry Files locally.}
\usage{
datasets.download_files(alias, files)
}
\arguments{
\item{alias}{The alias representing the Dataset.}

\item{files}{The file paths or file properties.}
}
\value{
A list mapping Foundry Dataset files to the local file paths where files were downloaded.
}
\description{
Download Foundry Files locally.
}
\examples{
\dontrun{
# Download a single file in a Dataset
downloaded_file <- datasets.download_files("my_alias", c("dir/my_file.csv"))
read.csv(downloaded_file$`dir/my_file.csv`)

# Extract text from all PDF files in a Dataset
pdf_files <- datasets.list_files("my_alias", regex = ".*\\\\.pdf")
downloaded_files <- datasets.download_files("my_alias", pdf_files)
contents <- lapply(downloaded_files, pdftools::pdf_text)
}

}
