#' Chicagoland floristic quality assessment data
#'
#' A data set summarizing 786 floristic quality assessments using the 2017
#' Chicago Region USACE database.
#'
#' @format A data frame with 52 columns:
#' \itemize{
#'    \item Title (character)
#'    \item Date (date)
#'    \item Site Name (character)
#'    \item City (character)
#'    \item County (character)
#'    \item State (character)
#'    \item Country (character)
#'    \item FQA DB Region (character)
#'    \item FQA DB Publication Year (character)
#'    \item FQA DB Description (character)
#'    \item Custom FQA DB Name (character)
#'    \item Custom FQA DB Description (character)
#'    \item Practitioner (character)
#'    \item Latitude (character)
#'    \item Longitude (character)
#'    \item Weather Notes (character)
#'    \item Duration Notes (character)
#'    \item Community Type Notes (character)
#'    \item Other Notes (character)
#'    \item Private/Public (character)
#'    \item Total Mean C (numeric)
#'    \item Native Mean C (numeric)
#'    \item Total FQI: (numeric)
#'    \item Native FQI (numeric)
#'    \item Adjusted FQI (numeric)
#'    \item \% C value 0 (numeric)
#'    \item \% C value 1-3 (numeric)
#'    \item \% C value 4-6 (numeric)
#'    \item \% C value 7-10 (numeric)
#'    \item Native Tree Mean C (numeric)
#'    \item Native Shrub Mean C (numeric)
#'    \item Native Herbaceous Mean C (numeric)
#'    \item Total Species (numeric)
#'    \item Native Species (numeric)
#'    \item Non-native Species
#'    \item Mean Wetness (numeric)
#'    \item Native Mean Wetness (numeric)
#'    \item Tree (numeric)
#'    \item Shrub (numeric)
#'    \item Vine (numeric)
#'    \item Forb (numeric)
#'    \item Grass (numeric)
#'    \item Sedge (numeric)
#'    \item Rush (numeric)
#'    \item Fern (numeric)
#'    \item Bryophyte (numeric)
#'    \item Annual (numeric)
#'    \item Perennial (numeric)
#'    \item Biennial (numeric)
#'    \item Native Annual (numeric)
#'    \item Native Perennial (numeric)
#'    \item Native Biennial (numeric)
#' }
#'
#' @source{\href{https://universalfqa.org/}{universalfqa.org}}
#' @docType data
#' @keywords datasets
"chicago"



#' Missouri floristic quality assessment data
#'
#' A data set summarizing 216 floristic quality assessments using the 2015
#' Missouri database.
#'
#' @format A data frame with 52 columns:
#' \itemize{
#'    \item Title (character)
#'    \item Date (date)
#'    \item Site Name (character)
#'    \item City (character)
#'    \item County (character)
#'    \item State (character)
#'    \item Country (character)
#'    \item FQA DB Region (character)
#'    \item FQA DB Publication Year (character)
#'    \item FQA DB Description (character)
#'    \item Custom FQA DB Name (character)
#'    \item Custom FQA DB Description (character)
#'    \item Practitioner (character)
#'    \item Latitude (character)
#'    \item Longitude (character)
#'    \item Weather Notes (character)
#'    \item Duration Notes (character)
#'    \item Community Type Notes (character)
#'    \item Other Notes (character)
#'    \item Private/Public (character)
#'    \item Total Mean C (numeric)
#'    \item Native Mean C (numeric)
#'    \item Total FQI: (numeric)
#'    \item Native FQI (numeric)
#'    \item Adjusted FQI (numeric)
#'    \item \% C value 0 (numeric)
#'    \item \% C value 1-3 (numeric)
#'    \item \% C value 4-6 (numeric)
#'    \item \% C value 7-10 (numeric)
#'    \item Native Tree Mean C (numeric)
#'    \item Native Shrub Mean C (numeric)
#'    \item Native Herbaceous Mean C (numeric)
#'    \item Total Species (numeric)
#'    \item Native Species (numeric)
#'    \item Non-native Species
#'    \item Mean Wetness (numeric)
#'    \item Native Mean Wetness (numeric)
#'    \item Tree (numeric)
#'    \item Shrub (numeric)
#'    \item Vine (numeric)
#'    \item Forb (numeric)
#'    \item Grass (numeric)
#'    \item Sedge (numeric)
#'    \item Rush (numeric)
#'    \item Fern (numeric)
#'    \item Bryophyte (numeric)
#'    \item Annual (numeric)
#'    \item Perennial (numeric)
#'    \item Biennial (numeric)
#'    \item Native Annual (numeric)
#'    \item Native Perennial (numeric)
#'    \item Native Biennial (numeric)
#' }
#'
#' @source{\href{https://universalfqa.org/}{universalfqa.org}}
#' @docType data
#' @keywords datasets
"missouri"
