% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailtyMMpen.R
\name{frailtyMMpen}
\alias{frailtyMMpen}
\title{Fitting penalized frailty models with clustered, multi-event and recurrent data using MM algorithm}
\usage{
frailtyMMpen(
  formula,
  data,
  frailty = "LogN",
  power = NULL,
  penalty = "LASSO",
  gam = NULL,
  tune = NULL,
  tol = 1e-05,
  maxit = 200,
  ...
)
}
\arguments{
\item{formula}{Formula where the left hand side is an object of the type \code{Surv}
and the right hand side contains the variables and additional specifications. 
\code{+cluster()} function specify the group id for clustered data or individual id for recurrent data.
\code{+event()} function specify the event id for multi-event data (only two events are allowed).}

\item{data}{The \code{data.frame} where the formula argument can be evaluated.}

\item{frailty}{The frailty used for model fitting. The default is "LogN", other choices are
"InvGauss", "Gamma" and "PVF". (Note that the computation time for PVF family will be slow 
due to the non-explicit expression of likelihood function)}

\item{power}{The power used if PVF frailty is applied.}

\item{penalty}{The penalty used for regularization, the default is "LASSO", other choices are "MCP" and "SCAD".}

\item{gam}{The tuning parameter for MCP and SCAD which controls the concavity of the penalty. For MCP, 
\deqn{p^{\prime}(\beta, \lambda)=sign(\beta)(\lambda - \frac{|\beta|}{\gamma})} and for "SCAD",
\deqn{p^{\prime}(\beta, \lambda)=\lambda\{I(|\beta| \leq \lambda)+\frac{(\gamma \lambda-|\beta|)_{+}}{(\gamma-1) \lambda} I(|\beta|>\lambda)\}.}
The default value of \eqn{\gamma} for MCP is 3 and SCAD is 3.7.}

\item{tune}{The sequence of tuning parameters provided by user. If not provided, the default grid will be applied.}

\item{tol}{The tolerance level for convergence.}

\item{maxit}{Maximum iterations for MM algorithm.}

\item{...}{additional arguments pass to the function.}
}
\value{
An object of class \code{fmm} that contains the following fields:
\item{coef}{matrix of coefficient estimated from a specific model.}
\item{est.tht}{vector of frailty parameter estimated from a specific model.}
\item{lambda}{list of frailty for each observation estimated from a specific model.}
\item{likelihood}{vector of the observed log-likelihood given estimated parameters.}
\item{BIC}{vector of the BIC given estimated parameters.}
\item{tune}{vector of tuning parameters used for penalized regression.}
\item{tune.min}{tuning parameter where minimal of BIC is obtained.}
\item{convergence}{convergence threshold.}
\item{input}{The input data re-ordered by cluster id. \code{y} is the event time, \code{X} is covariate matrix and \code{d} is the status while 0 indicates censoring.}
\item{y}{input stopping time.}
\item{X}{input covariate matrix.}
\item{d}{input censoring indicator.}
\item{formula}{formula applied as input.}
\item{coefname}{name of each coefficient from input.}
\item{id}{id for individuals or clusters, {1,2...,a}. Note that, since the original id may not be the sequence starting from 1, this output
id may not be identical to the original id. Also, the order of id is corresponding to the returned \code{input}.}
\item{N}{total number of observations.}
\item{a}{total number of individuals or clusters.}
\item{datatype}{model used for fitting.}
}
\description{
{This formula is used to fit the penalized regression. 3 types of the models can be fitted similar to the function
\code{frailtyMM}. In addition, variable selection can be done by three types of penalty, LASSO, MCP and SCAD with the following
objective function where \eqn{\lambda} is the tuning parameter and \eqn{q} is the dimension of \eqn{\boldsymbol{\beta}},
 \deqn{l(\boldsymbol{\beta},\Lambda_0|Y_{obs}) + n\sum_{p=1}^{q} p(|\beta_p|, \lambda).}
 The BIC is computed using the following equation,
 \deqn{-2l(\hat{\boldsymbol{\beta}}, \hat{\Lambda}_0) + G_n(\hat{S}+1)\log(n),}
 where \eqn{G_n=\max{1, \log(\log(q+1))}} and \eqn{\hat{S}} is the degree of freedom.
}
}
\details{
Without a given \code{tune}, the default sequence of tuning parameters are used to provide the regularization path.
The formula is same as the input for function \code{frailtyMM}.
}
\examples{

data(simdataCL)

# Penalized regression under clustered frailty model

# Clustered Gamma Frailty Model

# Using default tuning parameter sequence
gam_cl1 = frailtyMMpen(Surv(time, status) ~ . + cluster(id),
                       simdataCL, frailty = "Gamma")

\donttest{
# Using given tuning parameter sequence
gam_cl2 = frailtyMMpen(Surv(time, status) ~ . + cluster(id), 
                       simdataCL, frailty = "Gamma", tune = 0.1)

# Obtain the coefficient where minimum BIC is obtained
coef(gam_cl1)

# Obtain the coefficient with tune = 0.2.
coef(gam_cl1, tune = 0.2)

# Plot the regularization path
plot(gam_cl1)

# Get the degree of freedom and BIC for the sequence of tuning parameters provided
print(gam_cl1)

}

}
\references{
\itemize{
\item Huang, X., Xu, J. and Zhou, Y. (2022). Profile and Non-Profile MM Modeling of Cluster Failure Time and Analysis of ADNI Data. \emph{Mathematics}, 10(4), 538.
\item Huang, X., Xu, J. and Zhou, Y. (2023). Efficient algorithms for survival data with multiple outcomes using the frailty model. \emph{Statistical Methods in Medical Research}, 32(1), 118-132.
}
}
\seealso{
\code{\link{frailtyMM}}
}
