% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dummmies.R
\name{create_dummies}
\alias{create_dummies}
\title{create dummies}
\usage{
create_dummies(
  .data,
  ...,
  append_col_name = TRUE,
  max_levels = 10L,
  remove_first_dummy = FALSE,
  remove_most_frequent_dummy = FALSE,
  ignore_na = FALSE,
  split = NULL,
  remove_selected_columns = TRUE
)
}
\arguments{
\item{.data}{data frame}

\item{...}{tidyselect columns. default selection is all character or factor variables}

\item{append_col_name}{logical, default TRUE. Appends original column name to dummy col name}

\item{max_levels}{uses \code{\link[forcats]{fct_lump_n}} to limit the number of categories. Only the top n levels are preserved, and the rest being lumped into "other". Default is set to 10 levels, to prevent accidental overload. Set value to \code{Inf} to use all levels}

\item{remove_first_dummy}{logical, default FALSE.}

\item{remove_most_frequent_dummy}{logical, default FALSE}

\item{ignore_na}{logical, default FALSE}

\item{split}{NULL}

\item{remove_selected_columns}{logical, default TRUE}
}
\value{
data frame
}
\description{
adapted from the \code{\link[fastDummies]{dummy_cols}} function Added the option to truncate the dummy column
names, and to specify dummy cols using tidyselect.
}
\details{
reference the \href{https://jacobkap.github.io/fastDummies/index.html}{fastDummies} package for documentation on the original function.
}
\examples{

iris \%>\%
create_dummies(Species, append_col_name = FALSE) \%>\%
  tibble::as_tibble()


}
