% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{EffProbInf}
\alias{EffProbInf}
\title{EffProbInf}
\usage{
EffProbInf(dp, AR)
}
\arguments{
\item{dp}{A vector The design prevalence}

\item{AR}{A vector of the adjusted risks of the unit risk groups}
}
\value{
A vector of EPI
}
\description{
EffProbInf
}
\details{
Calculate the effective probability of infection (EPI) for each unsit
risk group in the population. This could be either at the herd
level or within herd level. The dp for herds is therefore the
minimum prevlance among herds that you would like to design the
surveillance system to be able to detect. The dp for within herds
is therefore the minimum prevalance of the disease within a herd
among the animals that you would like to design the surveillance
system to detect.
}
\examples{
df <- sample_data(nherds = 100,
                 mean_herd_size = 300,
                 n_herd_urg = 2,
                 herd_dist = c(0.9, 0.1),
                 herd_samp_frac = 0.01,
                 herd_samp_dist = c(0.3, 0.7),
                 n_animal_urg = 1,
                 animal_dist = c(1),
                 animal_samp_frac = 0.05,
                 animal_samp_dist = c(1),
                 seed = 1)
## The proportion of herds in each unit risk group
table(df$herd_urg)/nrow(df)
## Calculate the Adjusted risk for each unit risk group based on the
## proportion in each group and the estimated relative risk of being
## in that group:
AR <- freedom::adjusted_risk(as.numeric(table(df$herd_urg)/nrow(df)),
                             c(1, 2.3))
EPHI <- EffProbInf(0.05, AR)
}
