% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mris_convert.R
\name{mris_convert}
\alias{mris_convert}
\title{Use Freesurfers MRIs Converter}
\usage{
mris_convert(curv, orig, outfile = NULL, ext = ".asc", verbose = TRUE)
}
\arguments{
\item{curv}{(character) input filename for curve}

\item{orig}{(character) file path for origin file}

\item{outfile}{(character) output file path}

\item{ext}{(character) output file extension, default is set to .asc}

\item{verbose}{(logical) print diagnostic messages}
}
\value{
Name of output file
}
\description{
This function call  \code{mris_convert}, a 
general conversion program for converting between cortical surface file formats
}
\examples{
if (have_fs()) {
 bert_surf_dir = file.path(fs_subj_dir(), "bert", "surf")
 asc_file = mris_convert(
 curv = file.path(bert_surf_dir, "lh.thickness"), 
 orig = file.path(bert_surf_dir, "lh.white")
 )  
 res = read_fs_table(asc_file, header = FALSE)
 colnames(res) = c("index", "coord_1", "coord_2", "coord_3", "value")
} 
}

