% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_curv.R
\name{write.fs.curv}
\alias{write.fs.curv}
\title{Write file in FreeSurfer curv format}
\usage{
write.fs.curv(filepath, data)
}
\arguments{
\item{filepath, }{string. Full path to the output curv file. If it ends with ".gz", the file is written in gzipped format. Note that this is not common, and that other software may not handle this transparently.}

\item{data}{vector of floats. The brain morphometry data to write, one value per vertex.}
}
\description{
Write vertex-wise brain surface data to a file in FreeSurfer binary 'curv' format.
   For a subject (MRI image pre-processed with FreeSurfer) named 'bert', an example file would be 'bert/surf/lh.thickness', which contains n values. Each value represents the cortical thickness at the respective vertex in the brain surface mesh of bert.
}
\seealso{
Other morphometry functions: \code{\link{fs.get.morph.file.ext.for.format}},
  \code{\link{fs.get.morph.file.format.from.filename}},
  \code{\link{read.fs.curv}}, \code{\link{read.fs.mgh}},
  \code{\link{read.fs.morph}},
  \code{\link{read.fs.weight}}, \code{\link{write.fs.mgh}},
  \code{\link{write.fs.morph}},
  \code{\link{write.fs.weight}}
}
\concept{morphometry functions}
