% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fts.dpca.var.R
\name{fts.dpca.var}
\alias{fts.dpca.var}
\title{Proportion of variance explained by dynamic principal components}
\usage{
fts.dpca.var(F)
}
\arguments{
\item{F}{spectral density operator, provided as an object of class \code{\link{fts.freqdom}}. To guarantee accuracy of
numerical integration it is important that \code{F$freq} is a dense grid of frequencies in \eqn{[-\pi,\pi]}.}
}
\value{
A vector containing the \eqn{v_\ell}.
}
\description{
Computes the proportion and cumulative proportion of variance explained by dynamic principal components.
}
\details{
Consider a spectral density operator \eqn{\mathcal{F}_\omega} and let \eqn{\lambda_\ell(\omega)} by the \eqn{\ell}-th dynamic
eigenvalue. The proportion of variance described by the \eqn{\ell}-th dynamic principal component is given as
\eqn{v_\ell:=\int_{-\pi}^\pi \lambda_\ell(\omega)d\omega/\int_{-\pi}^\pi \mathrm{tr}(\mathcal{F}_\omega)d\omega}.
This function numerically computes the vectors \eqn{(v_\ell)}.

For more details we refer to Hormann et al. (2015).
}
\references{
Hormann, S., Kidzinski, L., and Hallin, M.
\emph{Dynamic functional principal components.} Journal of the Royal
Statistical Society: Series B (Statistical Methodology) 77.2 (2015): 319-348.
}
\seealso{
The multivariate equivalent in the \code{freqdom} package: \code{\link[freqdom]{dpca.var}}
}
\keyword{DPCA}
