% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reglag.significance.R
\name{reglag.significance}
\alias{reglag.significance}
\title{Test significance of coefficients in linear model estimator}
\usage{
reglag.significance(X, Y, A, alpha = 0.05, plot = FALSE, ...)
}
\arguments{
\item{X}{first multivariate time series}

\item{Y}{second multivariate time series}

\item{A}{estimated operators}

\item{alpha}{significance level}

\item{plot}{plot the results}

\item{...}{arguments passed to \code{\link{plot}} function}
}
\value{
list with a quantile and test statistics for each lag
}
\description{
Check significance of estimated coefficents in \code{\link{speclagreg}} estimator
}
\examples{
n = 200
d = 5
X = rar(n,d=d,Psi=matrix(0,d,d))  			# independent d-dim variables
w = 0.4
Y = w*X + (1-w)*rar(n,d=d,Psi=matrix(0,d,d))	# independent d-dim variables
A = speclagreg(X, Y, lags=-2:2)
W = reglag.significance(X, Y, A, alpha = 0.05)
}

