% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_multiview.R
\name{brainviews}
\alias{brainviews}
\title{Show one or more views of the given meshes in rgl windows.}
\usage{
brainviews(
  views,
  coloredmeshes,
  rgloptions = list(),
  rglactions = list(),
  style = "default",
  draw_colorbar = FALSE
)
}
\arguments{
\item{views}{list of strings. Valid entries include: 'si': single interactive view. 'sd_<angle>': single view from angle <angle>. The <angle> part must be one of the strings returned by \code{\link[fsbrain]{get.view.angle.names}}. Example: 'sd_caudal'. 'sr': single rotating view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{coloredmeshes}{list of coloredmesh or renderable. A coloredmesh is a named list as returned by the coloredmesh.from.* functions. It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh.}

\item{rgloptions}{option list passed to \code{\link[rgl]{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{style}{character string, a rendering style, e.g., 'default', 'shiny' or 'semitransparent'.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE. See \code{\link[fsbrain]{coloredmesh.plot.colorbar.separate}} for an alternative.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Show one or more views of the given meshes in rgl windows.
}
\seealso{
\code{\link[fsbrain]{get.view.angle.names}}
}
