% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglactions.R
\name{rglactions}
\alias{rglactions}
\title{Create rglactions list, suitable to be passed as parameter to vis functions.}
\usage{
rglactions()
}
\value{
named list, an example `rlgactions` instance that will save a screenshot of the plot produced by the vis function in the current working directory (see \code{getwd}), under the name 'fsbrain_out.png'.
}
\description{
Create rglactions list, suitable to be passed as parameter to vis functions.
}
\note{
List of all available rglactions: (1) `snapshot_png=filepath` takes a screenshot in PNG format and saves it in at `filepath`. (2) `trans_fun=function` uses the transformation function trans_fun to the data before mapping data values to colors and plotting. Popular transformation functions are \code{\link{limit_fun}}, \code{\link{limit_fun_na}}, and \code{\link{clip.data}}. (3) `text=arglist` calls \code{\link{text3d}} with the given args after plotting.
}
\examples{
   rgla_screenie = list('snapshot_png'='fsbain_out.png');
   rgla_screenie = rglactions();   # same as above
   rgla_clamp = list('trans_fun'=clip.data);
   rgla_limit = list('trans_fun'=limit_fun(2,5));
   rgla_ls = list('trans_fun'=limit_fun_na(2,5), 'snapshot_png'='~/fig1.png');
}
