% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg_stats.R
\name{qc.vis.failcount.by.region}
\alias{qc.vis.failcount.by.region}
\title{Visualize the number of outlier subjects per region in your dataset.}
\usage{
qc.vis.failcount.by.region(
  qc_res,
  atlas,
  subjects_dir = fsaverage.path(),
  subject_id = "fsaverage",
  ...
)
}
\arguments{
\item{qc_res}{hemilist of QC results, as returned by functions like \code{\link[fsbrain]{qc.for.group}} or \code{\link[fsbrain]{qc.from.segstats.tables}}.}

\item{atlas}{string. The brain atlas to use. E.g., 'aparc' or 'aparc.a2009s'.}

\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{...}{extra parameters passed to \code{\link[fsbrain]{vis.region.values.on.subject}}. E.g., to change to interactive view, get a colorbar and better resolution, try: \code{draw_colorbar=T, rgloptions = rglo(), views='si'}.}
}
\description{
The function helps you to see which regions are affected the most by QC issues: for each region, it plots the number of subjects which are outliers in the region.
}
\note{
You can visualize this on any subject you like, 'fsaverage' is a typical choice. The atlas must be the one used during the QC step.
}
