% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclustICsol.R
\name{tclustICsol}
\alias{tclustICsol}
\title{Extracts a set of best relevant solutions obtained by \code{\link{tclustIC}}}
\usage{
tclustICsol(
  out,
  NumberOfBestSolutions = 5,
  ThreshRandIndex = 0.7,
  whichIC = c("ALL", "CLACLA", "MIXMIX", "MIXCLA"),
  Rand = TRUE,
  msg = TRUE,
  plot = FALSE,
  trace = FALSE,
  ...
)
}
\arguments{
\item{out}{An S3 object of class \code{\link{tclustic.object}}
(output of \code{\link{tclustIC}}) containing the values
of the information criteria BIC (MIXMIX), ICL (MIXCLA) or CLA (CLACLA),
for different values of k (number of groups) and different
values of c (restriction factor), for a prespecified level of trimming.}

\item{NumberOfBestSolutions}{Number of best solutions to extract from BIC/ICL matrix.
The default value of NumberOfBestSolutions is 5}

\item{ThreshRandIndex}{Threshold to identify spurious solutions - the threshold
 of the adjusted Rand index to use to consider two solutions as equivalent.
The default value of ThreshRandIndex is 0.7}

\item{whichIC}{Specifies the information criterion to use to extract best solutions.
 Possible values for whichIC are:

 \itemize{
   \item \code{CLACLA} = in this case best solutions are referred to the classification likelihood.
   \item \code{MIXMIX} = in this case in this case best solutions are referred to the mixture likelihood (BIC).
   \item \code{MIXCLA} = in this case in this case best solutions are referred to ICL.
   \item \code{ALL} = in this case best solutions both three solutions using classification
     and mixture likelihood are produced. In the output class \code{out} all the
     three matrices \code{MIXMIXbs}, \code{CLACLAbs} and \code{MIXCLAbs} are given.
 }
 The default value is \code{whichIC="ALL"}.}

\item{Rand}{Index to use to compare partitions. If \code{Rand=TRUE} (default) the adjusted Rand
index is used, else the adjusted Fowlkes and Mallows index is used.}

\item{msg}{It controls whether to display or not messages (from MATLAB) on the screen. If \code{msg=TRUE}
(default) messages about the progression of the search are displayed on the screen
otherwise only error messages will be displayed.}

\item{plot}{If \code{plot=TRUE}, the best solutions which have been found are shown on the screen.}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{...}{potential further arguments passed to lower level functions.}
}
\value{
An S3 object of class \code{\link{tclusticsol.object}}
}
\description{
The function \code{tclustICsol()} takes as input an object of class
 \code{\link{tclustic.object}}, the output
 of function \code{\link{tclustIC}} (that is a series of matrices which contain
 the values of the information criteria BIC/ICL/CLA for different values of \code{k}
 and \code{c}) and extracts the first best solutions. Two solutions are considered
 equivalent if the value of the adjusted Rand index (or the adjusted Fowlkes and
 Mallows index) is above a certain threshold. For each tentative solution the program
 checks the adjacent values of \code{c} for which the solution is stable.
 A matrix with adjusted Rand indexes is given for the extracted solutions.
}
\examples{
 \dontrun{
 data(geyser2)
 out <- tclustIC(geyser2, whichIC="MIXMIX", plot=FALSE, alpha=0.1)

 ## Plot first two best solutions using as Information criterion MIXMIX
 print("Best solutions using MIXMIX")
 outMIXMIX <- tclustICsol(out, whichIC="MIXMIX", plot=TRUE, NumberOfBestSolutions=2)

 print(outMIXMIX$MIXMIXbs)
 }
}
\references{
Cerioli, A., Garcia-Escudero, L.A., Mayo-Iscar, A. and Riani M. (2017).
     Finding the Number of Groups in Model-Based Clustering via Constrained Likelihoods,
     emph{Journal of Computational and Graphical Statistics}, pp. 404-416,
     https://doi.org/10.1080/10618600.2017.1390469.

     Hubert L. and Arabie P. (1985), Comparing Partitions, \emph{Journal of Classification},
     Vol. 2, pp. 193-218.
}
\seealso{
\code{\link{tclustIC}}, \code{\link{tclustfsda}}, \code{\link{carbikeplot}}
}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
