% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtifit.R
\name{dtifit}
\alias{dtifit}
\title{DTI Fitting Procedure from FSL}
\usage{
dtifit(infile, bvecs, bvals, mask = NULL, outprefix = NULL, opts = "",
  bet.opts = "", verbose = TRUE, sse = FALSE, save_tensor = FALSE)
}
\arguments{
\item{infile}{Input filename}

\item{bvecs}{b-vectors: matrix of 3 columns or 
filename of ASCII text file}

\item{bvals}{b-values: vector of same length as number of rows of b-vectors
or filename of ASCII text file}

\item{mask}{Mask filename}

\item{outprefix}{Output prefix}

\item{opts}{Additional options for \code{dtifit}}

\item{bet.opts}{Options for \code{\link{fslbet}} if mask is not supplied}

\item{verbose}{print diagnostic messages}

\item{sse}{Save sum of squared errors}

\item{save_tensor}{Save tensor file out}
}
\value{
Vector of character filenames of output.  See Note
}
\description{
Calls \code{dtifit} from FSL
}
\note{
On successful completion of the command, the following files
will be output, which are:
\code{mask} - the mask used in the analysis
\code{outprefix}_V1 - 1st eigenvector
\code{outprefix}_V2 - 2nd eigenvector
\code{outprefix}_V3 - 3rd eigenvector
\code{outprefix}_L1 - 1st eigenvalue
\code{outprefix}_L2 - 2nd eigenvalue
\code{outprefix}_L3 - 3rd eigenvalue
\code{outprefix}_MD - mean diffusivity
\code{outprefix}_FA - fractional anisotropy
\code{outprefix}_MO - mode of the anisotropy (oblate ~ -1; isotropic ~ 0; prolate ~ 1)
\code{outprefix}_S0 - raw T2 signal with no diffusion weighting
optional output
If \code{sse = TRUE}, then the additional file will be present:
\code{outprefix}_sse - Sum of squared error
If \code{save_tensor = TRUE}, then the additional file will be present:
\code{outprefix}_tensor - tensor as a 4D file in this order: Dxx,Dxy,Dxz,Dyy,Dyz,Dzz
}
