% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fssem.R
\name{multiFSSEMiPALM2}
\alias{multiFSSEMiPALM2}
\title{multiFSSEMiPALM2}
\usage{
multiFSSEMiPALM2(Xs, Ys, Bs, Fs, Sk, sigma2, lambda, rho, Wl, Wf, p,
  maxit = 100, inert = inert_opt("linear"), threshold = 1e-06,
  verbose = TRUE, sparse = TRUE, trans = FALSE, B2norm = NULL,
  strict = FALSE)
}
\arguments{
\item{Xs}{eQTL matrices}

\item{Ys}{Gene expression matrices}

\item{Bs}{initialized GRN-matrices}

\item{Fs}{initialized eQTL effect matrices}

\item{Sk}{eQTL index of genes}

\item{sigma2}{initialized noise variance from ridge regression}

\item{lambda}{Hyperparameter of lasso term in FSSEM}

\item{rho}{Hyperparameter of fused-lasso term in FSSEM}

\item{Wl}{weight matrices for adaptive lasso terms}

\item{Wf}{weight matrix for adaptive fused lasso term}

\item{p}{number of genes}

\item{maxit}{maximum iteration number. Default 100}

\item{inert}{inertial function for iPALM. Default as k-1/k+2}

\item{threshold}{convergence threshold. Default 1e-6}

\item{verbose}{Default TRUE}

\item{sparse}{Sparse Matrix or not}

\item{trans}{Fs matrix is transposed to k x p or not. If Fs from ridge regression, trans = TRUE, else, trans = FALSE}

\item{B2norm}{B2norm matrices generated from ridge regression. Default NULL.}

\item{strict}{Converge strictly or not. Default False}
}
\value{
fit List of FSSEM model
\describe{
\item{Bs}{ coefficient matrices of gene regulatory networks}
\item{Fs}{ coefficient matrices of eQTL-gene effect}
\item{mu}{ Bias vector}
\item{sigma2}{ estimate of covariance in SEM}
}
}
\description{
Implementing FSSELM algorithm for network inference. If Xs is identify for different conditions, multiFSSEMiPALM will be use, otherwise, please
use \code{multiFSSEMiPALM2} for general cases
}
\examples{
seed = 1234
N = 100                                           # sample size
Ng = 5                                            # gene number
Nk = 5 * 3                                        # eQTL number
Ns = 1                                            # sparse ratio
sigma2 = 0.01                                     # sigma2
set.seed(seed)
library(fssemR)
data = randomFSSEMdata(n = N, p = Ng, k = Nk, sparse = Ns, df = 0.3, sigma2 = sigma2,
                       u = 5, type = "DG", nhub = 1, dag = TRUE)
## If we assume that different condition has different genetics perturbations (eQTLs)
data$Data$X = list(data$Data$X, data$Data$X)
## gamma = cv.multiRegression(data$Data$X, data$Data$Y, data$Data$Sk, ngamma = 20, nfold = 5,
##                            N, Ng, Nk)
gamma = 0.6784248     ## optimal gamma computed by cv.multiRegression
fit   = multiRegression(data$Data$X, data$Data$Y, data$Data$Sk, gamma, N, Ng, Nk,
                      trans = FALSE)
Xs    = data$Data$X
Ys    = data$Data$Y
Sk    = data$Data$Sk


cvfitc <- cv.multiFSSEMiPALM2(Xs = Xs, Ys = Ys, Bs = fit$Bs, Fs = fit$Fs, Sk = Sk,
                             sigma2 = fit$sigma2, nlambda = 5, nrho = 5,
                             nfold = 5, p = Ng, q = Nk, wt = TRUE)

fitc0 <- multiFSSEMiPALM2(Xs = Xs, Ys = Ys, Bs = fit$Bs, Fs = fit$Fs, Sk = Sk,
                          sigma2 = fit$sigma2, lambda = cvfitc$lambda, rho = cvfitc$rho,
                          Wl = inverseB(fit$Bs), Wf = flinvB(fit$Bs),
                          p = Ng, maxit = 100, threshold = 1e-5, sparse = TRUE, 
                          verbose = TRUE, trans = TRUE, strict = TRUE)


(TPR(fitc0$B[[1]], data$Vars$B[[1]]) + TPR(fitc0$B[[2]], data$Vars$B[[2]])) / 2
(FDR(fitc0$B[[1]], data$Vars$B[[1]]) + FDR(fitc0$B[[2]], data$Vars$B[[2]])) / 2
TPR(fitc0$B[[1]] - fitc0$B[[2]], data$Vars$B[[1]] - data$Vars$B[[2]])
FDR(fitc0$B[[1]] - fitc0$B[[2]], data$Vars$B[[1]] - data$Vars$B[[2]])
}
