% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTD.R
\name{CTD}
\alias{CTD}
\title{Composition_Transition_Distribution (CTD)}
\usage{
CTD(seqs, normalized = FALSE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
Output is a combination of three different matrices: Composition, Transition, and Distribution.
You can obtain any of the three matrices by executing the corresponding function, i.e., \link{CTDC}, \link{CTDT}, and \link{CTDD}.
}
\description{
This function calculates the composition, transition, and distribution for each sequence.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
CTDtotal<-CTD(seqs=filePrs,normalized=FALSE)

}
\references{
Dubchak, Inna, et al. "Prediction of protein folding class using global description of amino acid sequence." Proceedings of the National Academy of Sciences 92.19 (1995): 8700-8704.
}
