% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTorsionDir.R
\name{readTorsionDir}
\alias{readTorsionDir}
\title{Read Directory of Torsion predicted files (readTorsionDir)}
\usage{
readTorsionDir(dirPath)
}
\arguments{
\item{dirPath}{The path of the directory which contains all output files of SPINE-X. Each file belongs to a sequence.}
}
\value{
returns a list of vectors with all the predicted phi and psi angles for each amino acid. The length of the
list is the number of files(sequences) and the length of each vector is (2(phi-psi)*length sequence(i)).
}
\description{
This function reads a directory that contains the output files of SPINE-X.
It gets the directory path as the input and returns a list of vectors. Each vector includes the phi and psi angle
of the amino acids of the sequence.
}
\examples{


PredTorsioNdir<-system.file("testForder",package="ftrCOOL")
PredTorsioNdir<-paste0(PredTorsioNdir,"/TorsioNdir/")
PredVectASA<-readTorsionDir(PredTorsioNdir)

}
