% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_ant_admin.R
\name{format4pred}
\alias{format4pred}
\title{Preparation of inputs for predictions based on an fgpm modelCall}
\usage{
format4pred(sIn.pr = NULL, fIn.pr = NULL, args)
}
\arguments{
\item{sIn.pr}{sIn.pr an optional matrix of scalar input coordinates at which the output values should be
predicted. Each column is interpreted as a scalar input variable and each row as a coordinate.
Either scalar input coordinates (sIn.pr), functional input coordinates (fIn.pr), or both must be provided.
The \code{"\linkS4class{modelCall}"} object provided through args will lead the extraction of only the
active scalar inputs in the model.}

\item{fIn.pr}{an optional list of functional input coordinates at which the output values should be
predicted. Each element of the list is interpreted as a functional input variable. Every functional input
variable should be provided as a matrix with one curve per row. Either scalar input coordinates (sIn.pr),
functional input coordinates (fIn.pr), or both must be provided. The \code{"\linkS4class{modelCall}"}
object provided through args will lead the extraction of only the active functional inputs in the model.}

\item{args}{an object of class \code{"\linkS4class{modelCall}"}, which specifies the set of active
scalar and functional inputs.}
}
\value{
An object of class \code{"list"}, containing the input data structures with only the active inputs
  specified by \emph{args}.
}
\description{
This function prepared input data structures according to the active inputs specified by a
  \code{"\linkS4class{modelCall}"} object. This function is intended to easily adapt the data structures
  to the requirements of a specific model delivered by the model factory function
  \link[funGp]{fgpm_factory}.
}
\references{
Betancourt, J., Bachoc, F., and Klein, T. (2020),
R Package Manual: "Gaussian Process Regression for Scalar and Functional Inputs with funGp - The in-depth tour".
\emph{RISCOPE project}.
\href{https://hal.archives-ouvertes.fr/hal-02536624}{[HAL]}
}
\seealso{
\strong{*} \link[funGp]{predict} for predictions based on a funGp model;

\strong{*} \link[funGp]{fgpm} for creation of a funGp model;

\strong{*} \link[funGp]{fgpm_factory} for funGp heuristic model selection.
}
\author{
José Betancourt, François Bachoc and Thierry Klein
}
