% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{mfd}
\alias{mfd}
\title{Define a Multivariate Functional Data Object}
\usage{
mfd(coef, basisobj, fdnames = NULL, raw = NULL, id_var = NULL, B = NULL)
}
\arguments{
\item{coef}{A three-dimensional array of coefficients:

* the first dimension corresponds to basis functions.

* the second dimension corresponds to the number of
multivariate functional observations.

* the third dimension corresponds to variables.}

\item{basisobj}{A functional basis object defining the basis,
as provided to \code{fda::\link[fda]{fd}}, but there is no default.}

\item{fdnames}{A list of length 3, each member being a string vector
containing labels for the levels of the corresponding dimension
of the discrete data.

The first dimension is for a single character indicating the argument values,
i.e. the variable on the functional domain.

The second is for replications, i.e. it denotes the functional observations.

The third is for functional variables' names.}

\item{raw}{A data frame containing the original discrete data.
Default is NULL, however, if provided, it must contain:

a column (indicated by the \code{id_var} argument)
denoting the functional observations,
which must correspond to values in \code{fdnames[[2]]},

a column named as \code{fdnames[[1]]},
returning the argument values of each function

as many columns as the functional variables,
named as in \code{fdnames[[3]]},
containing the discrete functional values for each variable.}

\item{id_var}{A single character value indicating the column
in the \code{raw} argument
containing the functional observations (as in \code{fdnames[[2]]}),
default is NULL.}

\item{B}{A matrix with the inner products of the basis functions.
If NULL, it is calculated from the basis object provided.
Default is NULL.}
}
\value{
A multivariate functional data object
(i.e., having class \code{mfd}),
which is a list with components named
\code{coefs}, \code{basis}, and \code{fdnames},
as for class \code{fd},
with possibly in addition the components \code{raw} and \code{id_var}.
}
\description{
This is the constructor function for objects of the mfd class.
It is a wrapper to \code{fda::\link[fda]{fd}},
but it forces the coef argument to  be
a three-dimensional array of coefficients even if
the functional data is univariate.
Moreover, it allows to include the original raw data from which
you get the smooth functional data.
}
\details{
To check that an object is of this class, use function is.mfd.
}
\examples{
library(funcharts)
set.seed(0)
nobs <- 5
nbasis <- 10
nvar <- 2
coef <- array(rnorm(nobs * nbasis * nvar), dim = c(nbasis, nobs, nvar))
bs <- create.bspline.basis(rangeval = c(0, 1), nbasis = nbasis)
mfdobj <- mfd(coef = coef, basisobj = bs)
plot_mfd(mfdobj)

}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006),
\emph{Functional Data Analysis}, 2nd ed., Springer, New York.

Ramsay, James O., and Silverman, Bernard W. (2002),
\emph{Applied Functional Data Analysis}, Springer, New York.
}
