% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating.R
\name{compute_fit_stats}
\alias{compute_fit_stats}
\title{Statistics of model goodness-of-fit}
\usage{
compute_fit_stats(mCal, mPrd, fobs, xpr, nbK)
}
\arguments{
\item{mCal}{a numeric matrix.
This matrix is the matrix of performances predicted by the tree model.}

\item{mPrd}{a numeric matrix.
This matrix is the matrix of performances predicted by cross-validation.}

\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}

\item{nbK}{an integer.
This integer corresponds to the number of observed assembly motifs.}
}
\value{
Return statistics of model goodness-of-fit.
}
\description{
Taks a matrix of calibrations, a matrix of predictions,
  the vector of observed performances,
  the number of observed assembly motifs,
  and return a matrix of statistics for model goodness-of-fit.
}
\details{
Be careful, the matrix order is not ramdon.
The first argument \code{mCal} is matrix of modelled values.
The second argument \code{mPrd} is matrix of values
predicted by cross-validation.
The third argument \code{fobs} is the vector of observed values.
}
\keyword{internal}
