% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{cut_ftree}
\alias{cut_ftree}
\title{Cut a tree at a given level}
\usage{
cut_ftree(tree, nbcl)
}
\arguments{
\item{tree}{a list of a matrix of component affectation
and a vector of coefficients of determination.}

\item{nbcl}{an integer. \code{1 <= nbcl <= dim(tree$aff)[1]}.}
}
\value{
Return a vector of component affectation.
}
\description{
Take a tree and cut the matrix of component affectation
at a given level.
}
\details{
A hierarchical tree is recorded
as a list of matrix of component affectation
and a vector of coefficients of determination.\cr

The matrix of component affectation is a square matrix.
Its dimension is "number of leaves" = "number of components".
The clusters of components are labelled by integers, an integer by cluster.
The first line of the square matrix corresponds to the trivial cluster.
The trivial cluster get together all the components:
all components are thus labelled by one.
The second line separates the trivial cluster into 2 sub-clusters:
the components are labelled 1 or 2
according to the cluster to which they belong.
The following lines separate the trivial cluster into n sub-clusters,
labelled from 1 to the line numero.
The last line separate each component in a singleton cluster.\cr

The function \code{cut_ftree} samples the line \code{nbcl}
of the square matrix of component affectation.
}
\keyword{internal}
