% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{sort_ftree}
\alias{sort_ftree}
\title{Sort the resulting file of tree}
\usage{
sort_ftree(tree, index.return = FALSE)
}
\arguments{
\item{tree}{a list of a matrix of component affectation
and a vector of coefficients of determination.}

\item{index.return}{a logical.
If \code{index.return = TRUE},
 \code{sort_ftree} only returns the sorted matrix of component affectation.
If \code{index.return = FALSE},
 \code{sort_ftree} returns the sorted matrix of component affectation,
 the sorted indices and the sorted names of components.}
}
\value{
\item{index.return = TRUE}{\code{sort_ftree} returns
the sorted matrix of component affectation.
}
\item{index.return = FALSE}{\code{sort_ftree} returns
 the sorted matrix of component affectation,
 the sorted indices and the sorted names of components.
}
}
\description{
Take a tree, group the components by cluster,
and sort the clusters by increasing label.
Increasing label corresponds to increasing efficiency of the clusters.
}
\details{
A hierarchical tree is recorded
as a list of matrix of component affectation
and a vector of coefficients of determination.
The matrix of component affectation is a square matrix.
Its dimension is "number of leaves" = "number of components".
The clusters of components are labelled by integers, an integer by cluster.
The first line of the square matrix corresponds to the trivial cluster.
The trivial cluster get together all the components:
all components are thus labelled by one.
The second line separates the trivial cluster into 2 sub-clusters:
the components are labelled 1 or 2
according to the cluster to which they belong.
The following lines separate the trivial cluster into n sub-clusters,
labelled from 1 to the line numero.
The last line separate each component in a singleton cluster.
}
\keyword{internal}
