# WARNING - Generated by {fusen} from dev/flat_deal_with_flat_files.Rmd: do not edit by hand

dummypackage <- tempfile("deprecate")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(
  add_flat_template(
    template = "full",
    pkg = dummypackage, overwrite = TRUE, open = FALSE
  )
)
flat_file <- dev_file[grepl("flat_", dev_file)]

# Detect all files created ----
usethis::with_project(dummypackage, {
  # Create empty config file

  # Inflate once
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  config_file <- file.path("dev", "config_fusen.yaml")
  config_origin <- yaml::read_yaml(config_file)

  deprecate_flat_file(flat_file = flat_file)

  test_that("deprecate_flat_file is moved to flat_history", {
    expect_false(file.exists(flat_file))
    expect_true(
      file.exists(file.path("dev", "flat_history", basename(flat_file)))
    )
    expect_equal(
      readLines(file.path("dev", "flat_history", basename(flat_file)))[1],
      "<!-- # WARNING - flat file now deprecated. do not edit by hand, do not inflate -->"
    )
  })

  config <- yaml::read_yaml(config_file)

  test_that("deprecate_flat_file is updated in config file", {
    expect_true(config[[basename(flat_file)]]$state == "deprecated")
    # path and flat_file are modified in config file
    expect_equal(
      config[[basename(flat_file)]]$path,
      file.path("dev", "flat_history", basename(flat_file))
    )
    expect_equal(
      config[[basename(flat_file)]]$inflate$flat_file,
      file.path("dev", "flat_history", basename(flat_file))
    )
    # The rest does not change
    expect_equal(
      config[[basename(flat_file)]][
        c("R", "tests", "vignettes")
      ],
      config_origin[[basename(flat_file)]][
        c("R", "tests", "vignettes")
      ]
    )
  })

  test_that("deprecate_flat_file changes 'do not edit by hand'", {
    # Search for "do not edit by hand" in files generated by the flat file
    # and listed in the config file
    all_linked_files <- unlist(
      config[[basename(flat_file)]][
        c("R", "tests", "vignettes")
      ]
    )
    expect_false(
      any(
        sapply(all_linked_files, function(file) {
          any(grepl("# do not edit by hand", readLines(file)))
        })
      )
    )
    expect_true(
      all(
        sapply(all_linked_files, function(file) {
          any(
            grepl(
              paste0(
                "# Previously generated by \\{fusen\\} from ",
                file.path("dev", "flat_history", basename(flat_file)),
                ": now deprecated."
              ),
              readLines(file)
            )
          )
        })
      )
    )
  })

  test_that("deprecate_flat_file stops if flat file does not exist", {
    expect_error(deprecate_flat_file(flat_file = "dev/flat_nonexistent.Rmd"),
      regexp = "does not exist"
    )
  })

  file.create("dev/flat_nonexistent.Rmd")
  test_that("deprecate_flat_file stops if flat file is not in config file", {
    expect_error(deprecate_flat_file(flat_file = "dev/flat_nonexistent.Rmd"),
      regexp = "is not in the config file"
    )
  })

  file.create("dev/flat_full.Rmd")
  config[[basename(flat_file)]]$state <- "deprecated"
  write_yaml_verbatim(config, config_file)
  test_that("deprecate_flat_file stops if flat file is already deprecated", {
    expect_message(
      deprecate_flat_file(flat_file = flat_file),
      "is already deprecated"
    )
  })
})
