% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyHeatwaves.R
\name{apply_all_models}
\alias{apply_all_models}
\title{Apply a function across heat waves from all projections}
\usage{
apply_all_models(out, FUN, city_specific = FALSE, ...)
}
\arguments{
\item{out}{Character string with pathname to which extreme event files were
written by \code{\link{gen_hw_set}}. Typically, this will be the same
pathname as that specified with \code{out} when running
\code{\link{gen_hw_set}}.}

\item{FUN}{A character string with the name of a function to apply to
the extreme event dataframes located in the directory specified by
\code{out}. This function must take the argument, \code{hw_datafr},
a dataframe of identified and characterized extreme events, as generated by
\code{\link{gen_hw_set}}. For an example of one of these dataframes, load
the \code{\link{hw_datafr}} data. The function should output a single
value when applied to the full extreme event dataframe. The function can
also have other arguments, which are passed through the \code{...}
argument of \code{apply_all_models}.}

\item{city_specific}{TRUE or FALSE, specifying whether the function should
be applied separately for each study location.}

\item{...}{Optional arguments to \code{FUN}.}
}
\value{
A dataframe with the value output by the \code{FUN} function, as
   applied to all the extreme event dataframes generated by \code{gen_hw_set}.
}
\description{
This function will take a user-specified function and apply it across
all the extreme event files created by \code{\link{gen_hw_set}}.
It will generate either a single value for every ensemble member within
every climate model, if \code{city_specific} is set to \code{FALSE}, or
a value for every city for every ensemble member, if
\code{city_specific} is set to \code{TRUE}.
}
\note{
The function input as \code{FUN} must follow a very specific
   structure. It most have as an argument a dataframe with characterized
   extreme events, as generated by the \code{\link{gen_hw_set}} function.
   See the \code{futureheatwaves} vignette for more guidance on creating and
   applying a custom function to explore the extreme events identified and
   characterized by \code{\link{gen_hw_set}}.
}
\examples{
ex_results <- system.file("extdata/example_results",
                          package = "futureheatwaves")
apply_all_models(ex_results, FUN = average_mean_temp)
apply_all_models(ex_results, FUN = average_mean_temp,
                 city_specific = TRUE)

}

