% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgnc2uniprot.R
\name{hgnc2uniprot}
\alias{hgnc2uniprot}
\title{Mapping from Hugo symbol to UniProt IDs}
\usage{
hgnc2uniprot(hgnc.symbol)
}
\arguments{
\item{hgnc.symbol}{primary HUGO symbol}
}
\value{
a data frame with columns \emph{symbol} (Hugo symbol), \emph{uniprot} (UniProt ID),
and \emph{length} (protein length).
}
\description{
Mapping from Hugo Symbol to UniProt ID using internal mapping table.
Return a data frame with columns \emph{symbol} (Hugo symbol), \emph{uniprot} (UniProt ID),
and \emph{length} (protein length).
}
\examples{
# maps to single UniProt entry
hgnc2uniprot("TP53")

# maps to multiple UniProt entries
hgnc2uniprot("GNAS")
hgnc2uniprot("AKAP7")

}
