% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{hover_activate}
\alias{hover_activate}
\title{Configure Hover Activate Behavior}
\usage{
hover_activate(
  key = "hover-activate",
  animation = TRUE,
  enable = TRUE,
  degree = 0,
  direction = c("both", "in", "out"),
  state = "active",
  inactiveState = NULL,
  onHover = NULL,
  onHoverEnd = NULL,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior (string, default: "hover-activate").}

\item{animation}{Whether to enable animation (boolean, default: TRUE).}

\item{enable}{Whether to enable hover feature (boolean or JS function, default: TRUE).}

\item{degree}{Degree of relationship to activate elements (number or JS function, default: 0).}

\item{direction}{Specify edge direction: "both", "in", or "out" (string, default: "both").}

\item{state}{State of activated elements (string, default: "active").}

\item{inactiveState}{State of inactive elements (string, default: NULL).}

\item{onHover}{Callback when element is hovered (JS function, default: NULL).}

\item{onHoverEnd}{Callback when hover ends (JS function, default: NULL).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/hover-activate}.}
}
\value{
A list with the configuration settings for the hover-activate behavior.
}
\description{
Creates a configuration object for the hover-activate behavior in G6.
This behavior activates elements when the mouse hovers over them.
}
\examples{
# Basic configuration
config <- hover_activate()

# Custom configuration
config <- hover_activate(
  key = "my-hover-behavior",
  animation = FALSE,
  degree = 1,
  direction = "out",
  state = "highlight",
  inactiveState = "inactive",
  onHover = JS("(event) => { console.log('Hover on:', event.target.id); }")
)
}
