/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class PdfContentReaderTool {
    public static String getDictionaryDetail(PdfDictionary pdfDictionary) {
        return PdfContentReaderTool.getDictionaryDetail(pdfDictionary, 0);
    }

    public static String getDictionaryDetail(PdfDictionary pdfDictionary, int n) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        ArrayList<PdfName> arrayList = new ArrayList<PdfName>();
        Object object2 = pdfDictionary.getKeys().iterator();
        while (object2.hasNext()) {
            object = (PdfName)object2.next();
            PdfObject pdfObject = pdfDictionary.getDirectObject((PdfName)object);
            if (pdfObject.isDictionary()) {
                arrayList.add((PdfName)object);
            }
            stringBuffer.append(object);
            stringBuffer.append('=');
            stringBuffer.append(pdfObject);
            stringBuffer.append(", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer.append(')');
        object = arrayList.iterator();
        while (object.hasNext()) {
            object2 = (PdfName)object.next();
            stringBuffer.append('\n');
            for (int i = 0; i < n + 1; ++i) {
                stringBuffer.append('\t');
            }
            stringBuffer.append("Subdictionary ");
            stringBuffer.append(object2);
            stringBuffer.append(" = ");
            stringBuffer.append(PdfContentReaderTool.getDictionaryDetail(pdfDictionary.getAsDict((PdfName)object2), n + 1));
        }
        return stringBuffer.toString();
    }

    public static void listContentStream(File file) throws IOException {
        int n = -1;
        PdfReader pdfReader = new PdfReader(file.getCanonicalPath());
        int n2 = pdfReader.getNumberOfPages();
        if (n != -1) {
            n2 = n;
        }
        for (int i = 1; i <= n2; ++i) {
            int n3;
            System.out.println("==============Page " + i + "====================");
            System.out.println("- - - - - Dictionary - - - - - -");
            PdfDictionary pdfDictionary = pdfReader.getPageN(i);
            System.out.println(PdfContentReaderTool.getDictionaryDetail(pdfDictionary));
            System.out.println("- - - - - Content Stream - - - - - -");
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            byte[] byArray = pdfReader.getPageContent(i, randomAccessFileOrArray);
            randomAccessFileOrArray.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            while ((n3 = ((InputStream)byteArrayInputStream).read()) != -1) {
                System.out.print((char)n3);
            }
            System.out.println("- - - - - Text Extraction - - - - - -");
            PdfTextExtractor pdfTextExtractor = new PdfTextExtractor(pdfReader);
            System.out.println(pdfTextExtractor.getTextFromPage(i));
            System.out.println();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage:  PdfContentReaderTool <pdf file path>");
            return;
        }
        PdfContentReaderTool.listContentStream(new File(stringArray[0]));
    }
}

