/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeWeight {
    private static final Log logger = LogFactory.getLog(EdgeWeight.class);
    protected String weightStr = null;
    protected double[] weight = null;
    static DecimalFormat formatSmall = new DecimalFormat("#.###E0");
    public static final String[] greekLaTeX = new String[]{"\\\\alpha", "\\\\beta", "\\\\gamma", "\\\\delta", "\\\\epsilon", "\\\\zeta", "\\\\eta", "\\\\theta", "\\\\iota", "\\\\kappa", "\\\\lambda", "\\\\mu", "\\\\nu", "\\\\xi", "\\\\omicron", "\\\\pi", "\\\\rho", "\\\\sigma", "\\\\tau", "\\\\nu", "\\\\phi", "\\\\chi", "\\\\psi", "\\\\omega"};
    public static final char[] greek = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9'};

    public EdgeWeight(String weightStr) {
        this.weightStr = weightStr;
    }

    public EdgeWeight(double weight) {
        this.weight = new double[]{weight};
        this.setWeightStr(weight);
    }

    private void setWeightStr(double weight) {
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        this.weightStr = !Configuration.getInstance().getGeneralConfig().showFractions() ? (weight != 0.0 && weight < Math.pow(0.1, Configuration.getInstance().getGeneralConfig().getDigits()) ? formatSmall.format(weight) : format.format(weight)) : (weight != 0.0 && weight < Math.pow(0.1, Configuration.getInstance().getGeneralConfig().getDigits()) ? formatSmall.format(weight) : RControl.getFraction((Double)weight, true));
    }

    public String toString() {
        return this.weightStr;
    }

    public double[] getWeight(Hashtable<String, Double> ht) {
        try {
            String s;
            String replaceStr = this.weightStr;
            if (this.weight != null) {
                return this.weight;
            }
            Enumeration<String> keys = ht.keys();
            while (keys.hasMoreElements()) {
                s = keys.nextElement();
                for (int i = 0; i < greek.length; ++i) {
                    if (!("" + greek[i]).equals(s)) continue;
                    replaceStr = replaceStr.replaceAll("" + greekLaTeX[i], "" + ht.get(s));
                }
            }
            keys = ht.keys();
            while (keys.hasMoreElements()) {
                s = keys.nextElement();
                replaceStr = replaceStr.replaceAll(s, "" + ht.get(s));
            }
            replaceStr = replaceStr.replaceAll("\\\\epsilon", "epsilon");
            this.weight = RControl.getR().eval("gMCP:::parseEpsPolynom(\"" + replaceStr.replaceAll("\\\\", "\\\\\\\\") + "\")").asRNumeric().getData();
            return this.weight;
        }
        catch (Exception e) {
            logger.warn((Object)("Error parsing edge weight:\n" + e.getMessage()));
            return new double[]{Double.NaN};
        }
    }

    public List<String> getVariables() {
        int i;
        String replaceStr = this.weightStr;
        Vector<String> variables = new Vector<String>();
        for (i = 0; i < greek.length; ++i) {
            if ((replaceStr = replaceStr.replaceAll(greekLaTeX[i], "" + greek[i])).lastIndexOf(greek[i]) == -1) continue;
            variables.add("" + greek[i]);
        }
        for (i = 0; i < 26; ++i) {
            char l = (char)(97 + i);
            if (replaceStr.lastIndexOf(l) == -1) continue;
            variables.add("" + l);
        }
        return variables;
    }

    public String getLaTeXStr() {
        if (this.weight != null && this.weight.length == 1) {
            return RControl.getR().eval("gMCP:::getLaTeXFraction(" + this.weight[0] + ")").asRChar().getData()[0];
        }
        String replaceStr = this.weightStr;
        for (int i = 0; i < greek.length; ++i) {
            replaceStr = replaceStr.replaceAll("" + greek[i], greekLaTeX[i]);
        }
        return replaceStr;
    }
}

