/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.SingleDataFramePanel;
import org.af.gMCP.gui.dialogs.MatrixCreationDialog;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.PDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CVPanel
extends JPanel
implements ActionListener {
    PDialog pd;
    CreateGraphGUI parent;
    Vector<Node> nodes;
    SingleDataFramePanel dfp;
    SingleDataFramePanel dfpTest;
    boolean containsNA;
    JCheckBox secondCV = new JCheckBox("Use another correlation matrix of test statistics used by the parametric test (misspecified or contains NA values)");
    JButton loadCV = new JButton("Load Matrix from R");
    JButton createCV = new JButton("Advanced Matrix Creation");

    public CVPanel(PDialog pd) {
        this.pd = pd;
        this.parent = pd.getParent();
        this.nodes = this.parent.getGraphView().getNL().getNodes();
        RDataFrameRef df = new RDataFrameRef();
        RDataFrameRef df2 = new RDataFrameRef();
        for (Node n : this.nodes) {
            df.addRowCol(n.getName());
            df2.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
            df2.setValue(df2.getColumnCount() - 1, df2.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new SingleDataFramePanel(df);
        this.dfp.getTable().getModel().checkCorMat();
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.dfp.getTable().getModel().setCheckRowSum(false);
        this.dfpTest = new SingleDataFramePanel(df);
        this.dfpTest.getTable().getModel().checkCorMat();
        this.dfpTest.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfpTest.getTable()));
        this.dfpTest.getTable().getModel().setCheckRowSum(false);
        this.dfpTest.setEnabled(false);
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            try {
                String mat = this.parent.getPView().jcbCorObject.getSelectedItem().toString();
                this.load(this.dfp, mat);
                this.load(this.dfpTest, mat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            String name = this.parent.getPView().jcbCorObject.getSelectedItem().toString();
            this.containsNA = RControl.getR().eval("any(is.na(" + name + "))").asRLogical().getData()[0];
            try {
                double[] result = RControl.getR().eval("as.numeric(" + name + ")").asRNumeric().getData();
                int n = this.nodes.size();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                        this.dfpTest.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                    }
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(pd, "Could not load matrix \"" + name + "\":\n" + exc.getMessage(), "Could not load matrix", 0);
            }
        }
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            rows = rows + ", pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        }
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            if (this.containsNA) {
                this.add((Component)new JLabel("Correlation matrix used by parametric test (can be changed in the main window)"), cc.xyw(2, row, 3));
            } else {
                this.add((Component)new JLabel("Correlation matrix used by parametric test and simulation (has to be changed in the main window)"), cc.xyw(2, row, 3));
            }
            this.add((Component)new JScrollPane(this.dfpTest), cc.xyw(2, row += 2, 3));
            row += 2;
        }
        if (!this.parent.getPView().jrbRCorrelation.isSelected() || this.containsNA) {
            if (this.containsNA) {
                this.add((Component)new JLabel("For the simulation setting please sepcify values for the NA entries"), cc.xyw(2, row, 3));
            } else {
                this.add((Component)new JLabel("Correlation matrix of test statistics for power simulations"), cc.xyw(2, row, 3));
            }
            this.add((Component)new JScrollPane(this.dfp), cc.xyw(2, row += 2, 3));
            this.add((Component)this.loadCV, cc.xy(2, row += 2));
            this.loadCV.addActionListener(this);
            this.add((Component)this.createCV, cc.xy(4, row));
            this.createCV.addActionListener(this);
        }
    }

    private void load(SingleDataFramePanel dfp) {
        VariableNameDialog vnd = new VariableNameDialog(this.parent);
        if (!RControl.getR().eval("gMCP:::checkQuadraticMatrix(" + vnd.getName() + ", n=" + this.nodes.size() + ")").asRLogical().getData()[0]) {
            JOptionPane.showMessageDialog(this.pd, "Can not get a numeric quadradtic matric from \"" + vnd.getName() + "\" of dimension " + this.nodes.size() + "x" + this.nodes.size() + ".", "Not a numeric quadratic matrix of correct dimension", 0);
            return;
        }
        this.load(dfp, vnd.getName());
    }

    private void load(SingleDataFramePanel dfp3, String name) {
        try {
            String force = "";
            if (!RControl.getR().eval("gMCP:::checkCorrelation(" + name + ")").asRLogical().getData()[0]) {
                int answer = JOptionPane.showConfirmDialog(this.pd, "Matrix is not a correlation matrix. Should it be forced to be symmetric and normalized?", "Not a correlation matrix", 0);
                if (answer == 1) {
                    return;
                }
                force = "gMCP:::forceCorrelation";
            }
            double[] result = RControl.getR().eval("as.numeric(" + force + "(" + name + "))").asRNumeric().getData();
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.pd, "Could not load matrix \"" + name + "\":\n" + exc.getMessage(), "Could not load matrix", 0);
        }
    }

    String getMatrixForParametricTest() {
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            SingleDataFramePanel df = this.dfpTest;
            return ", corr.test=" + df.getTable().getModel().getDataFrame().getRMatrix() + ", upscale=\"" + Configuration.getInstance().getGeneralConfig().getUpscale() + "\"";
        }
        return "";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.secondCV) {
            return;
        }
        if (e.getSource() == this.createCV) {
            MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, this.dfp.getTable().getRMatrix(), MatrixCreationDialog.getNames(this.parent.getGraphView().getNL().getNodes()));
            this.dfp.getTable().getModel().copy(mcd.dfp.getTable().getModel());
            return;
        }
        if (e.getSource() == this.loadCV) {
            this.load(this.dfp);
            return;
        }
    }

    public String getSigma() {
        if (this.parent.getPView().jrbRCorrelation.isSelected() && !this.containsNA) {
            return this.dfpTest.getTable().getModel().getDataFrame().getRMatrix();
        }
        return this.dfp.getTable().getModel().getDataFrame().getRMatrix();
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("scenarios");
        e.setAttribute("secondCV", "" + this.secondCV.isSelected());
        int n = this.nodes.size();
        Element e1 = document.createElement("cv1." + n);
        Element e2 = document.createElement("cv2." + n);
        for (int i = 0; i < n; ++i) {
            Element eRow1 = document.createElement("Row" + (i + 1));
            Element eRow2 = document.createElement("Row" + (i + 1));
            for (int j = 0; j < n; ++j) {
                Element eCol1 = document.createElement("Col" + (j + 1));
                Element eCol2 = document.createElement("Col" + (j + 1));
                eCol1.setAttribute("value", this.dfp.getTable().getModel().getValueAt(i, j).toString());
                eCol2.setAttribute("value", this.dfpTest.getTable().getModel().getValueAt(i, j).toString());
                eRow1.appendChild(eCol1);
                eRow2.appendChild(eCol2);
            }
            e1.appendChild(eRow1);
            e2.appendChild(eRow2);
        }
        e.appendChild(e1);
        e.appendChild(e2);
        return e;
    }

    public void loadConfig(Element e) {
        this.secondCV.setSelected(Boolean.parseBoolean(e.getAttribute("secondCV")));
        int n = this.nodes.size();
        Element cv1 = (Element)e.getElementsByTagName("cv1." + n).item(0);
        Element cv2 = (Element)e.getElementsByTagName("cv2." + n).item(0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (cv1 != null) {
                    this.dfp.getTable().getModel().setValueAt(new EdgeWeight(Double.parseDouble(((Element)cv1.getChildNodes().item(i).getChildNodes().item(j)).getAttribute("value"))), i, j);
                }
                if (cv2 == null) continue;
                this.dfpTest.getTable().getModel().setValueAt(new EdgeWeight(Double.parseDouble(((Element)cv2.getChildNodes().item(i).getChildNodes().item(j)).getAttribute("value"))), i, j);
            }
        }
        this.repaint();
    }
}

