% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndset.R
\name{addNDSet}
\alias{addNDSet}
\title{Add discrete points to a non-dominated set and classify them into extreme supported, non-extreme
supported, non-supported.}
\usage{
addNDSet(
  pts,
  nDSet = NULL,
  crit = "max",
  keepDom = FALSE,
  dubND = FALSE,
  classify = TRUE
)
}
\arguments{
\item{pts}{A data frame with points to add (a column for each objective).}

\item{nDSet}{A data frame with current non-dominated set (NULL is none yet). Column names of the
p objectives must be \verb{z1, ..., zp}.}

\item{crit}{A max or min vector. If length one assume all objectives are optimized in the same
direction.}

\item{keepDom}{Keep dominated points in output.}

\item{dubND}{Duplicated non-dominated points are classified as non-dominated.}

\item{classify}{Non-dominated points are classified into supported extreme (\code{se}), supported
non-extreme (\code{sne}) and unsupported (\code{us})}
}
\value{
A data frame with a column for each objective (\code{z} columns) and \code{nd} (non-dominated).
Moreover if \code{classify} then columns \code{se}, \code{sne}, \code{us} and \code{cls}.
}
\description{
Add discrete points to a non-dominated set and classify them into extreme supported, non-extreme
supported, non-supported.
}
\examples{
nDSet <- data.frame(z1=c(12,14,16,18), z2=c(18,16,12,4))
pts <- data.frame(z1 = c(18,18,14,15,15), z2=c(2,6,14,14,16))
addNDSet(pts, nDSet, crit = "max")
addNDSet(pts, nDSet, crit = "max", keepDom = TRUE)
addNDSet(pts, nDSet, crit = "min")
addNDSet(c(2,2), nDSet, crit = "max")
addNDSet(c(2,2), nDSet, crit = "min")

addNDSet(c(2,2), crit = "min")

\donttest{
nDSet <- data.frame(z1=c(12,14,16,18), z2=c(18,16,12,4), z3 = c(1,7,0,6))
pts <- data.frame(z1=c(12,14,16,18), z2=c(18,16,12,4), z3 = c(2,2,2,6))
crit = c("min", "min", "max")
di <- c(1,1,-1)
li <- c(-1,20)
ini3D(argsPlot3d = list(xlim = li, ylim = li, zlim = li))
plotCones3D(nDSet, direction = di, argsPolygon3d = list(color = "green", alpha = 1),
            drawPoint = FALSE)
plotHull3D(nDSet, addRays = TRUE, direction = di)
plotPoints3D(nDSet, argsPlot3d = list(col = "red"), addText = "coord")
plotPoints3D(pts, addText = "coord")
finalize3D()
addNDSet(pts, nDSet, crit, dubND = FALSE)
addNDSet(pts, nDSet, crit, dubND = TRUE)
addNDSet(pts, nDSet, crit, dubND = TRUE, keepDom = TRUE)
addNDSet(pts, nDSet, crit, dubND = TRUE, keepDom = TRUE, classify = FALSE)
}
}
\author{
Lars Relund \email{lars@relund.dk}
}
