% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ggm_grips.R
\name{fit_ggm_grips}
\alias{fit_ggm_grips}
\title{Fit Gaussian graphical models}
\usage{
fit_ggm_grips(
  S,
  formula = NULL,
  nobs,
  K = NULL,
  maxit = 10000L,
  eps = 0.01,
  convcrit = 1,
  aux = list(),
  method = "covips",
  print = 0
)
}
\arguments{
\item{S}{Sample covariance matrix.}

\item{formula}{Generators of model; a list of integer vectors or a 2
x p matrix of integers.}

\item{nobs}{Number of observations}

\item{K}{Initial value of concentration matrix.}

\item{maxit}{Maximum number of iterations.}

\item{eps}{Convergence criterion.}

\item{convcrit}{Convergence criterions. See section \code{details}.}

\item{aux}{A list of form name=value.}

\item{method}{Either \code{"ips"} or \code{"fips"}.}

\item{print}{Should output from fitting be printed?}
}
\description{
Fit Gaussian graphical models using various algorithms.
}
\details{
Convergence criterion:
\itemize{
\item 1: max absolute difference between S and Sigmahat on edges.
\item 2: difference in log likelihood divided by number of parameters in the
model (number of edges + number of nodes) between successive
iterations.
\item 3: computed duality gap may turn negative due to rounding error, so its absolute value is returned.
This still provides upper bound on error of likelihood function.
}

R-based / c++-based in combination with con / cov.
}
\examples{
options("digits"=3)
data(math, package="gRbase")

S <- cov(math)
nobs <- nrow(math)
gl <- list(1:3, 3:5)
em <- matrix(c(1,2, 2,3, 1,3, 3,4, 3,5, 4,5), nrow=2)

EPS = 1e-2

fit_cov = fit_ggm_grips(S, gl, nobs=nobs, eps=EPS, method="cov")
fit_con = fit_ggm_grips(S, gl, nobs=nobs, eps=EPS, method="con")
fit_ncd = fit_ggm_grips(S, gl, nobs=nobs, eps=EPS, method="ncd")

K <- solve(S)
(fit_con$K - K)  |> abs() |> max()
(fit_cov$K - K)  |> abs() |> max()
(fit_ncd$K - K)  |> abs() |> max()

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
