#' Generate a citation for occurrence data
#'
#' If a \code{data.frame} was generated using \code{\link{ala_occurrences}},
#' and the \code{mint_doi} argument was set to \code{TRUE}, the DOI associated
#' with that dataset is appended to the resulting \code{data.frame} as an
#' attribute. This function simply formats that DOI as a citation that can be 
#' included in a scientific publication. Please also consider citing this package,
#' using the information in \code{citation("galah")}.
#' @param data data.frame: occurrence data generated by \code{\link{ala_occurrences}}
#' @return A string containing the citation for that dataset.
#' @export ala_citation

ala_citation <- function(data) {
  if (is.na(attributes(data)$doi)) {
    search_url <- attributes(data)$search_url
    if (is.na(search_url)) {
      stop("This dataset does not have a DOI or associated search url.
      Please download again and then use `ala_citation`.")
    }
    return(paste0("ALA occurrence download accessed from R with galah",
           " (https://github.com/AtlasOfLivingAustralia/galah/) on ",
           Sys.Date(), ". Search url: ", search_url)
    )
  }
  paste0("ALA occurrence download ", attributes(data)$doi,
         ". Accessed from R with galah",
         " (https://github.com/AtlasOfLivingAustralia/galah/) on ",
         Sys.Date(), ".")
}