% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_polygon.R, R/st_crop.R
\name{galah_polygon}
\alias{galah_polygon}
\alias{st_crop.data_request}
\title{Narrow a query to within a specified polygon}
\usage{
galah_polygon(...)

\method{st_crop}{data_request}(x, y, ...)
}
\arguments{
\item{...}{When supplied to \code{galah_polygon()}, a single \code{sf} object, WKT
string or shapefile. Currently ignored when supplied to
\code{st_crop.data_request()}}

\item{x}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{y}{A single \code{sf} object, WKT string or shapefile}
}
\value{
length-1 object of class \code{character} and \code{galah_geolocate},
containing a multipolygon WKT string representing the area provided.
}
\description{
Restrict results to those from a specified area. Areas must be polygons.
Polygons must be supplied as an \code{sf} object, a 'well-known text' (WKT)
string, or a shapefile. Polygons and shapefiles must not be overly complex
(i.e. have too many characters or too many vertices) or they will not be
accepted in a query to the ALA.
}
\details{
WKT strings longer than 10000 characters and
\code{sf} objects with more than 500 vertices will not be
accepted by the ALA. Some polygons  may need to be simplified.
}
\examples{
\dontrun{
# Search for records within a polygon using an `sf` object
location <- "POLYGON((142.3 -29.0,142.7 -29.1,142.7 -29.4,142.3 -29.0))" |>
  sf::st_as_sfc()
galah_call() |>
  galah_identify("reptilia") |>
  galah_polygon(location) |>
  atlas_counts()

# Search for records using a shapefile
galah_config(email = "your_email_here")
location <- galah_geolocate(sf::st_read(path/to/shapefile.shp))
galah_call() |>
  galah_identify("vulpes") |>
  galah_polygon(location) |>
  atlas_occurrences()

# Search for records using a Well-known Text string (WKT)
wkt <- "POLYGON((142.3 -29.0,142.7 -29.1,142.7 -29.4,142.3 -29.0))"
galah_call() |>
  galah_identify("vulpes") |>
  galah_polygon(wkt) |>
  atlas_counts()
}
}
\seealso{
\code{\link[=galah_bbox]{galah_bbox()}} & \code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to narrow
queries by location. \code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_select]{galah_select()}} for other ways to restrict the information
returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
\keyword{internal}
