% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dose_fit.R, R/dose_predict.R
\docType{methods}
\name{doserate}
\alias{doserate}
\alias{dose_fit}
\alias{dose_fit-method}
\alias{dose_predict}
\alias{dose_predict-method}
\alias{dose_fit,GammaSpectra,GammaSpectrum,matrix-method}
\alias{dose_fit,GammaSpectra,GammaSpectrum,data.frame-method}
\alias{dose_fit,GammaSpectra,data.frame-method}
\alias{dose_predict,CalibrationCurve,missing-method}
\alias{dose_predict,CalibrationCurve,GammaSpectrum-method}
\alias{dose_predict,CalibrationCurve,GammaSpectra-method}
\title{Dose Rate Estimation}
\usage{
dose_fit(object, background, doses, ...)

dose_predict(object, spectrum, ...)

\S4method{dose_fit}{GammaSpectra,GammaSpectrum,matrix}(
  object,
  background,
  doses,
  range_Ni,
  range_NiEi,
  details = list(authors = "", date = Sys.time())
)

\S4method{dose_fit}{GammaSpectra,GammaSpectrum,data.frame}(
  object,
  background,
  doses,
  range_Ni,
  range_NiEi,
  details = list(authors = "", date = Sys.time())
)

\S4method{dose_predict}{CalibrationCurve,missing}(object, sigma = 1, epsilon = 1.5)

\S4method{dose_predict}{CalibrationCurve,GammaSpectrum}(object, spectrum, sigma = 1, epsilon = 1.5)

\S4method{dose_predict}{CalibrationCurve,GammaSpectra}(object, spectrum, sigma = 1, epsilon = 1.5)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectra} or \linkS4class{CalibrationCurve} object.}

\item{background}{A \linkS4class{GammaSpectrum} object of a length-two \code{\link{numeric}}
vector giving the background noise integration value and error,
respectively.}

\item{doses}{A \code{\link{matrix}} or \code{\link{data.frame}} TODO.}

\item{...}{Currently not used.}

\item{spectrum}{An optional \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra}
object in which to look for variables with which to predict. If omitted,
the fitted values are used.}

\item{range_Ni, range_NiEi}{A length-two \code{\link{numeric}} vector giving the energy
range to integrate within (in keV).}

\item{details}{A \code{\link{list}} of length-one vector specifying additional
informations about the instrument for which the curve is built.}

\item{sigma}{A \code{\link{numeric}} value giving TODO.}

\item{epsilon}{A \code{\link{numeric}} value giving an extra error term
introduced by the calibration of the energy scale of the spectrum.}
}
\value{
\itemize{
\item \code{dose_fit()} returns a \linkS4class{CalibrationCurve} object.
\item \code{dose_predict()} returns a \code{\link{data.frame}} with the following columns:
\describe{
\item{\code{name}}{(\code{\link{character}}) the name of the spectra.}
\item{\verb{*_signal}}{(\code{\link{numeric}}) the integrated signal value (according to
the value of \code{threshold}; see \code{\link[=signal_integrate]{signal_integrate()}}).}
\item{\verb{*_error}}{(\code{\link{numeric}}) the integrated signal error value
(according to the value of \code{threshold}; see \code{\link[=signal_integrate]{signal_integrate()}}).}
\item{\code{gamma_signal}}{(\code{\link{numeric}}) the predicted gamma dose rate.}
\item{\code{gamma_error}}{(\code{\link{numeric}}) the predicted gamma dose rate error.}
}
}
}
\description{
\code{dose_fit} builds a calibration curve for gamma dose rate estimation.
}
\details{
\code{dose_predict} predicts in situ gamma dose rate.

To estimate the gamma dose rate, one of the calibration curves distributed
with this package can be used. These built-in curves are in use in several
luminescence dating laboratories and can be used to replicate published
results. As these curves are instrument specific, the user may have to build
its own curve.

The construction of a calibration curve requires a set of reference spectra
for which the gamma dose rate is known and a background noise measurement.
First, each reference spectrum is integrated over a given interval, then
normalized to active time and corrected for background noise. The dose rate
is finally modelled by the integrated signal value used as a linear
predictor (York \emph{et al.}, 2004).

See \code{vignette(doserate)} for a reproducible example.
}
\examples{
## Import CNF files
## Spectra
spc_dir <- system.file("extdata/BDX_LaBr_1/calibration", package = "gamma")
spc <- read(spc_dir)

## Background
bkg_dir <- system.file("extdata/BDX_LaBr_1/background", package = "gamma")
bkg <- read(bkg_dir)

## Get dose rate values
data("clermont")
(doses <- clermont[, c("gamma_dose", "gamma_error")])

## Build the calibration curve
calib_curve <- dose_fit(spc, bkg, doses,
                        range_Ni = c(300, 2800),
                        range_NiEi = c(165, 2800))

## Plot the curve
plot(calib_curve, threshold = "Ni")

## Estimate gamma dose rates
dose_predict(calib_curve, spc)
}
\references{
Mercier, N. & Falguères, C. (2007). Field Gamma Dose-Rate Measurement with
a NaI(Tl) Detector: Re-Evaluation of the "Threshold" Technique.
\emph{Ancient TL}, 25(1), p. 1-4.

York, D., Evensen, N. M., Martínez, M. L. & De Basabe Delgado, J. (2004).
Unified Equations for the Slope, Intercept, and Standard Errors of the Best
Straight Line. \emph{American Journal of Physics}, 72(3), p. 367-75.
\doi{10.1119/1.1632486}.
}
\seealso{
\code{\link[=signal_integrate]{signal_integrate()}}
}
\author{
N. Frerebeau
}
\concept{dose rate}
