% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdGenerate.R
\name{gdGenerate}
\alias{gdGenerate}
\title{Generate generative data for a data source}
\usage{
gdGenerate(
  inDataSourceFileName,
  outGenerativeDataFileName,
  numberOfIterations,
  keepProbability,
  columnIndices
)
}
\arguments{
\item{inDataSourceFileName}{Name of data source file}

\item{outGenerativeDataFileName}{Name of generative data file}

\item{numberOfIterations}{Number of iterations.
In this version the limit of number of iterations is set to 25000.}

\item{keepProbability}{Value in the range of 0 to 1 which is used in training of neural networks to train generalized networks.}

\item{columnIndices}{Vector of two column indices that are used to show two-dimensional projections of normalized generated generative data and
data source for a training step in RStudio Plots pane. Indices refer to indices of active columns of data source.}
}
\value{
None
}
\description{
Read a data source from a file, generate generative data for the data source in iterative training steps and
write generated generative data to a file in binary format. When a higher number of iterations is used 
the distribution of generated generative data gets closer to that of the data source.
}
\examples{
\donttest{gdGenerate("iris4d.bin", "gd.bin", 2500, 0.95, c(1, 2))}
}
