% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaView-generics.R, R/GaView-methods.R
\docType{methods}
\name{ga_view_selector}
\alias{ga_view_selector}
\alias{GaView}
\alias{GaView<-}
\alias{GaView,gaProperty,missing-method}
\alias{GaView,gaAccount,missing-method}
\alias{GaView,ANY,missing-method}
\alias{GaView,.query,missing-method}
\alias{GaView,.query,ANY-method}
\alias{GaView<-,.query-method}
\title{ga_view_selector}
\usage{
ga_view_selector(creds = GoogleApiCreds(), with_gui = FALSE)

GaView(object, value)

GaView(object) <- value

\S4method{GaView}{gaProperty,missing}(object)

\S4method{GaView}{gaAccount,missing}(object)

\S4method{GaView}{ANY,missing}(object)

\S4method{GaView}{.query,missing}(object)

\S4method{GaView}{.query,ANY}(object, value)

\S4method{GaView}{.query}(object) <- value
}
\arguments{
\item{creds}{Optional. An OAuth2.0 credentials object to use for the request.}

\item{with_gui}{Optional. Boolean value indicating whether to use a GUI for
the menu. Default is \code{FALSE}.}

\item{object}{An object to coerce to a \code{gaView} object or to get the
gaView of, such as a query, default view of a web property, or the default
view of the first web property in a Google Analytics account.}

\item{value}{The optional replacement view if the object supplied is a query,
in which case \code{GaView} will return the modified query.}
}
\value{
A \code{gaView} object.
}
\description{
A menu user-interface for selecting a Google Analytics view.

Get the view ID of the query.

Set the view ID for the query.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = gaProperty,value = missing}: Select the default view of the property.

\item \code{object = gaAccount,value = missing}: Select the default view of the first listed property of
the account.

\item \code{object = ANY,value = missing}: Returns the ID of the supplied view, or the default view
within the supplied property or the default view within the first property
of the supplied account, or coerces a numeric or character into a
\code{viewId}.

\item \code{object = .query,value = missing}: gets the view ID of the supplied query.

\item \code{object = .query,value = ANY}: Set the view of a query, returning the query with the
updated view applied.

\item \code{.query}: Replaces the view being used by a query.
}}

\examples{
\dontrun{
   my_ga_account <- GaAccounts()[['60253332']]
   my_website_property <- my_ga_account$properties[['UA-60253332-2']]
   my_default_view <- GaView(my_website_property)
}
\dontrun{
   my_ga_account <- GaAccounts()[['60253332']]
   my_default_view <- GaView(my_ga_account)
}
}
