% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circos.mhtplot2.R
\name{circos.mhtplot2}
\alias{circos.mhtplot2}
\title{Another circos Manhattan plot}
\usage{
circos.mhtplot2(dat, labs, species = "hg18", ticks = 0:3 * 10, y = 20)
}
\arguments{
\item{dat}{Data to be plotted with variables chr, pos, log10p.}

\item{labs}{Data on labels.}

\item{species}{Genome build.}

\item{ticks}{Tick positions.}

\item{y}{Starting position of y-axis label.}
}
\value{
There is no return value but a plot.
}
\description{
Another circos Manhattan plot
}
\details{
This is adapted from work for a recent publication. It enables a y-axis to the -log10(P) for association statistics
}
\examples{
\dontrun{
require(gap.datasets)
library(dplyr)
glist <- c("IRS1","SPRY2","FTO","GRIK3","SNED1","HTR1A","MARCH3","WISP3",
           "PPP1R3B","RP1L1","FDFT1","SLC39A14","GFRA1","MC4R")
testdat <- mhtdata[c("chr","pos","p","gene","start","end")] \%>\%
           rename(log10p=p) \%>\%
           mutate(chr=paste0("chr",chr),log10p=-log10(log10p))
dat <- mutate(testdat,start=pos,end=pos) \%>\%
       select(chr,start,end,log10p)
labs <- subset(testdat,gene \%in\% glist) \%>\%
        group_by(gene,chr,start,end) \%>\%
        summarize() \%>\%
        mutate(cols="blue") \%>\%
        select(chr,start,end,gene,cols)
labs[2,"cols"] <- "red"
circos.mhtplot2(dat,labs,ticks=0:2*10)
# https://www.rapidtables.com/web/color/RGB_Color.html
}
}
