% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gargle-package.R, R/ui.R
\name{gargle_options}
\alias{gargle_options}
\alias{gargle_oauth_email}
\alias{gargle_oob_default}
\alias{gargle_oauth_cache}
\alias{gargle_quiet}
\title{Options consulted by gargle}
\usage{
gargle_oauth_email()

gargle_oob_default()

gargle_oauth_cache()

gargle_quiet()
}
\description{
Wrapper functions around options consulted by gargle, which provide:
\itemize{
\item A place to hang documentation.
\item The mechanism for setting a default.
}

If the built-in defaults don't suit you, set one or more of these options.
Typically, this is done in the \code{.Rprofile} startup file, with code along
these lines:\preformatted{options(
  gargle_oauth_email = "jane@example.com",
  gargle_oauth_cache = "/path/to/folder/that/does/not/sync/to/cloud"
)
}
}
\section{\code{gargle_oauth_email}}{

\code{gargle_oauth_email()} returns the option named "gargle_oauth_email", which
is undefined by default. If set, this option should be one of:
\itemize{
\item An actual email address corresponding to your preferred Google identity.
Example:\code{janedoe@gmail.com}.
\item \code{TRUE} to allow email and OAuth token auto-discovery, if exactly one
suitable token is found in the cache.
\item \code{FALSE} or \code{NA} to force the OAuth dance in the browser.
}
}

\section{\code{gargle_oob_default}}{

\code{gargle_oob_default()} returns the option named "gargle_oob_default",
defaulting to \code{FALSE}. This controls whether to prefer "out of band"
authentication. This is ultimately passed to \code{\link[httr:init_oauth2.0]{httr::init_oauth2.0()}} as
\code{use_oob}. If \code{FALSE} (and httpuv is installed), a local webserver is used
for the OAuth dance. Otherwise, user gets a URL and prompt for a validation
code.
}

\section{\code{gargle_oauth_cache}}{

\code{gargle_oauth_cache()} returns the option named "gargle_oauth_cache",
defaulting to \code{NA}. If defined, the option must be set to a logical value or
a string. \code{TRUE} means to cache using the default user-level cache file,
\code{~/.R/gargle/gargle-oauth}, \code{FALSE} means don't cache, and \code{NA} means to
guess using some sensible heuristics.
}

\section{\code{gargle_quiet}}{

\code{gargle_quiet()} returns the option named "gargle_quiet", which defaults to
\code{TRUE}. Set this option to \code{FALSE} to see more info about gargle's
activities, which can be helpful for troubleshooting.
}

\examples{
gargle_oauth_email()
gargle_oob_default()
gargle_oauth_cache()
gargle_quiet()
}
