% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gargle-class.R
\docType{class}
\name{Gargle-class}
\alias{Gargle-class}
\alias{Gargle2.0}
\title{OAuth2 token objects specific to Google APIs}
\format{An R6 class object.}
\usage{
Gargle2.0
}
\description{
This is based on the \link[httr:Token-class]{Token2.0} class provided in httr.
These objects should be created through the constructor function
\code{\link[=gargle2.0_token]{gargle2.0_token()}}. Key differences:
\itemize{
\item The key for a cached \code{Token2.0} comes from hashing the endpoint, app, and
scopes. For the \code{Gargle2.0} subclass, the identifier or key is expanded to
include the email address associated with the token. This makes it easier to
work with Google APIs with multiple identities.
\item \code{Gargle2.0} tokens are cached, by default, below
\code{"~/.R/gargle/gargle-oauth"}, i.e. at the user level. In contrast, the
default location for \code{Token2.0} is \code{./.httr-oauth}, i.e. in current working
directory. \code{Gargle2.0} behaviour makes it easier to reuse tokens across
projects and makes it less likely that tokens are accidentally synched to a
remote location like GitHub or DropBox.
\item Each \code{Gargle2.0} token is cached in its own file. The token cache is a
directory of such files. In contrast, \code{Token2.0} tokens are cached as
components of a list, which is typically serialized to \code{./.httr-oauth}.
}
}
\keyword{internal}
