% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factory.R
\name{import_factory_cals}
\alias{import_factory_cals}
\title{Import instrument-specific factory calibration files from a folder.}
\usage{
import_factory_cals(
  folder = tools::R_user_dir("gasanalyzer", which = "config"),
  keep = FALSE
)
}
\arguments{
\item{folder}{A folder where calibration files are to be found.}

\item{keep}{Copies valid calibration files to a package-specific
configuration folder. Will result in automatic import of the data in the
future. Will overwrite files.}
}
\value{
Calibration data is stored in the package environment.
}
\description{
The factory calibration of the 6800 can be used to calculate
concentrations from raw values. The calibration files are found
in subfolders of /home/licor/.factory on the instrument. They can be copied
to a computer and imported to the package configuration files using this
method.
}
\details{
The function will also load the calibration into the package environment,
where they can be retrieved by \code{\link[=get_factory_cals]{get_factory_cals()}}.

This method assumes the files are named with serial number and calibration
date, separated by an underscore.
}
\examples{
exampledir <- system.file("extdata", package = "gasanalyzer")

# show calibration data
get_factory_cals()

# import factory calibration for example data:
import_factory_cals(exampledir)

# show calibration data
get_factory_cals()

}
\seealso{
\code{\link[=get_factory_cals]{get_factory_cals()}}
}
