% Generated by roxygen2 (4.0.1): do not edit by hand
\name{evaluatorLM}
\alias{evaluatorLM}
\title{LM Evaluator}
\usage{
evaluatorLM(statistic = c("BIC", "AIC", "adjusted.r.squared", "r.squared"),
  numThreads = NULL)
}
\arguments{
\item{statistic}{The statistic used to evaluate the fitness}

\item{numThreads}{The maximum number of threads the algorithm is allowed to spawn (a value less than 1 or NULL means no threads)}
}
\value{
Returns an S4 object of type \code{\link{GenAlgLMEvaluator}}
}
\description{
Create an evaluator that uses a linear model to evaluate the fitness.
}
\details{
Different statistics to evaluate the fitness of the variable subset can be given. If a maximum
absolute correlation is given the algorithm will be very slow (as the C++ implementation can not
be used anymore) and multithreading is not available.
}
\examples{
ctrl <- genAlgControl(populationSize = 200, numGenerations = 30, minVariables = 5,
    maxVariables = 12, verbosity = 1)
evaluator <- evaluatorLM(statistic = "BIC", numThreads = 1)

# Generate demo-data
set.seed(12345)
X <- matrix(rnorm(10000, sd = 1:5), ncol = 50, byrow = TRUE)
y <- drop(-1.2 + rowSums(X[, seq(1, 43, length = 8)]) + rnorm(nrow(X), 1.5));

result <- genAlg(y, X, control = ctrl, evaluator = evaluator, seed = 123)

subsets(result, 1:5)
}
\seealso{
Other GenAlg.Evaluators: \code{\link{evaluatorFit}};
  \code{\link{evaluatorPLS}};
  \code{\link{evaluatorUserFunction}}
}

