% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPFVN.R
\name{HPFVN}
\alias{HPFVN}
\title{High Pass Filter Von Neumann Estimator.}
\usage{
HPFVN(wcn, evalues, b)
}
\arguments{
\item{wcn}{Noisy wavelet coefficients.}

\item{evalues}{Laplacian spectrum.}

\item{b}{Parameter that control the number of scales.}
}
\description{
Graph extension of the Von Neummann variance estimator using finest scale coefficients.
}
\examples{
graphname <- "grid1"
groupname <- "AG-Monien"
graph <- download_graph(graphname,groupname)
A <- graph$sA
L <- laplacian_mat(A)
n <- nrow(L)
val1 <- eigensort(L)
evalues <- val1$evalues
evectors <- val1$evectors
lmax <- max(evalues)
f <- randsignal(eta=0.01,k=5,A=A)
sigma <- 0.1
noise <- rnorm(n, sd = sigma)
y <- f + noise
b <- 2
wcn <- forward_sgwt(y, evalues, evectors, b=b)
HPFVN(wcn, evalues, b)
}
\references{
von Neumann, J. (1941). Distribution of the ratio of the mean square successive difference to the variance. \emph{Ann. Math. Statistics}, 35(3), 433--451.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.
}
