% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgraphstst.R
\name{fgraphstst}
\alias{fgraphstst}
\title{Calculates an independence graph for a set of variables using  repeated stepwise selection}
\usage{
fgraphstst(x, alpha, nu = 1, kmax = 0, nedge = 10^6,
  intercept = TRUE, chkintercept = FALSE)
}
\arguments{
\item{x}{The variables}

\item{alpha}{Cut-off p-value}

\item{nu}{Order statistic}

\item{kmax}{Maximum number selected variables for each node}

\item{nedge}{Maximum number of edges}

\item{intercept}{If true intercept included}

\item{chkintercept}{If true intercept included depending on p-value}

}
\value{
ned Number of edges

edg The edges for each node in the graph
}
\description{
Calculates an independence graph for a set of variables using  repeated stepwise selection
}
\examples{
data(redwine)
redwgrph<-fgraphstst(redwine[,1:11],0.01)
redwgrph[[1]]
redwgrph[[2]]
}
