`tcl` <-
function (df, t.nlev = 3, g = gainr, inf.lim = 0.5, tcl.verbose = T, 
    ...) 
{
    tcl.version <- "0.1f"
    if (tcl.verbose) 
        cat("tcl", tcl.version, " with inf.lim", inf.lim, "\n")
    if (is.factor(df[, ncol(df)])) 
        df[, ncol(df)] <- as.vector(df[, ncol(df)])
    outcomes <- df[, ncol(df)]
    efun <- function(v, branch, ...) (unlist(v[branch$test$attribute]) == 
        branch$test$value) + 0
    op <- function(a, b) a + b
    if (t.nlev > 1) {
        if (tcl.verbose) 
            cat("Creating Fuzzy tree with", t.nlev, "levels.\n")
        mf <- genmemfuns(df[, -ncol(df)], nlev = t.nlev)
        df <- fdisc(df, mf)
    }
    tree <- rpart(df[, -ncol(df), drop = F], outcomes = outcomes, 
        rankf = g, inf.lim = min(inf.lim, infa(outcomes)), tcl.verbose = tcl.verbose)
    attlist <- tree.tests(tree)
    if (t.nlev > 1) {
        mf <- mf[attlist]
        efun <- function(v, branch, mf, ...) mf[[branch$test$attribute]][[branch$test$value]](v[branch$test$attribute])
        efun <- makefun(efun, list(mf = mf))
        op <- function(a, b) pmax(a, b)
    }
    fun <- function(x = NULL, tree, applicator, printer, efun, 
        op, ds, ...) applicator(tree, x, printer, efun, op, ds, 
        ...)
    cl <- makefun(fun, list(x = NULL, tree = tree, applicator = tree.apply, 
        printer = print.tree, efun = efun, op = op, ds = paste(mktcl.licensestr(), 
            paste("generated by tcl", tcl.version), sep = "\n")))
    environment(cl) <- globalenv()
    attr(cl, "summary.tcl.natt") <- length(attlist)
    attr(cl, "summary.tcl.nlev") <- t.nlev
    attr(cl, "summary.tcl.ilim") <- inf.lim
    return(cl)
}
