% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{extr_val}
\alias{extr_val}
\title{Extract parts of an object}
\usage{
extr_val(x, i, allNA_NA = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{object from which to extract element(s)}

\item{i}{index specifying element to extract.}

\item{allNA_NA}{logical indicating whether \code{NA} should be returned
when \code{all(is.na(i)) == TRUE}.}

\item{na.rm}{a logical indicating whether missing index values should be 
removed.}
}
\value{
If \code{all_NA = FALSE} and \code{na.rm = FALSE}, identical to 
   \code{x[i]}.
   
   If \code{all_NA = FALSE} and \code{na.rm = TRUE}, identical to
   \code{x[i[!is.na(i)]]}.
   
   If \code{all_NA = TRUE}, identical to \code{x[i]} unless 
   \code{all(is.na(i)) == TRUE}, in which case returns \code{NA}
}
\description{
A wrapper for \code{[} with handling of NA's for use in
\code{dplyr::summarize()}
}
