% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/batch_gdal_translate.R
\name{batch_gdal_translate}
\alias{batch_gdal_translate}
\title{batch_gdal_translate}
\usage{
batch_gdal_translate(infiles, outdir, outsuffix = "_conv.tif",
  pattern = NULL, recursive = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{infiles}{Character. A directory or a character vector of files (including their path).  If a directory, all files matching the pattern will be converted.}

\item{outdir}{Character. Output directory to save the output files.}

\item{outsuffix}{Character. The suffix to append to the input filename (minus its extension) to generate the output filename(s).}

\item{pattern}{Character. If infiles is a directory, this is used to limit the file it is searching for.}

\item{recursive}{Logical. If infiles is a directory, should files be searched for recursively?}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}

\item{...}{Parameters to pass to \code{\link{gdal_translate}}}
}
\value{
Either a list of NULLs or a list of RasterBricks depending on whether output_Raster is set to TRUE.
}
\description{
Runs gdal_translate on a batch of files
}
\details{
This function is designed to run gdal_translate in batch mode.  Files are
passed to the function either directly as a character vector of filenames, or by
passing it a directory and (typically) a search pattern (e.g. pattern=".tif").  gdal_translate
will execute based on parameters passed to it, and the output file will be named based on the
input file (stripped of its extension), with the outsuffix appended to it.

If a parallel engine is started and registered with foreach, this program will run in parallel
(one gdal_translate per worker).
}
\examples{
\dontrun{
input_folder <- system.file("external",package="gdalUtils")
list.files(input_folder,pattern=".tif")
output_folder <- tempdir()
# library(spatial.tools)
# sfQuickInit() # from package spatial.tools to launch a parallel PSOCK cluster
batch_gdal_translate(infiles=input_folder,outdir=output_folder,
	outsuffix="_converted.envi",of="ENVI",pattern=".tif$")
list.files(output_folder,pattern="_converted.envi$")
# sfQuickStop() # from package spatial.tools to stop a parallel PSOCK cluster
}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net})
}
\references{
\url{http://www.gdal.org/gdal_translate.html}
}
\seealso{
\code{\link{gdal_translate}}, \code{\link{list.files}}
}

