% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy.R
\name{raster_cube_dummy}
\alias{raster_cube_dummy}
\title{Create a dummy data cube with a fill value}
\usage{
raster_cube_dummy(view, nbands = 1, fill = 1, chunking = c(16, 256, 256))
}
\arguments{
\item{view}{a data cube view defining the shape (spatiotemporal extent, resolution, and spatial reference)}

\item{nbands}{number of bands}

\item{fill}{fill value}

\item{chunking}{vector of length 3 defining the size of data cube chunks in the order time, y, x.}
}
\value{
a proxy data cube object
}
\description{
Create a data cube with a constant fill value for one or more bands from a data cube view. Use this cube for testing.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
v = cube_view(extent=list(left=388941.2, right=766552.4, 
                         bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
             srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
L8.cube = raster_cube_dummy(v, 1, 2.345)
}
