% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{create}
\alias{create}
\title{Create a new uninitialized raster}
\usage{
create(format, dst_filename, xsize, ysize, nbands, dataType, options = NULL)
}
\arguments{
\item{format}{Raster format short name (e.g., "GTiff" or "HFA").}

\item{dst_filename}{Filename to create.}

\item{xsize}{Integer width of raster in pixels.}

\item{ysize}{Integer height of raster in pixels.}

\item{nbands}{Integer number of bands.}

\item{dataType}{Character data type name.
(e.g., common data types include Byte, Int16, UInt16, Int32, Float32).}

\item{options}{Optional list of format-specific creation options in a
vector of "NAME=VALUE" pairs
(e.g., \code{options = c("COMPRESS=LZW")} to set LZW
compression during creation of a GTiff file).
The APPEND_SUBDATASET=YES option can be
specified to avoid prior destruction of existing dataset.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{create()} makes an empty raster in the specified format.
}
\examples{
new_file <- paste0(tempdir(), "/", "newdata.tif")
create(format="GTiff", dst_filename=new_file, xsize=143, ysize=107,
       nbands=1, dataType="Int16")
ds <- new(GDALRaster, new_file, read_only=FALSE)
## EPSG:26912 - NAD83 / UTM zone 12N
ds$setProjection(epsg_to_wkt(26912))
gt <- c(323476.1, 30, 0, 5105082.0, 0, -30)
ds$setGeoTransform(gt)
ds$setNoDataValue(band = 1, -9999)
ds$fillRaster(band = 1, -9999, 0)
## ...
## close the dataset when done
ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=createCopy]{createCopy()}}, \code{\link[=rasterFromRaster]{rasterFromRaster()}}
}
